/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.unittest.utils.matchers;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.unittest.utils.utils.SizeUtils;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class HasSameSizeAs<T>
extends BaseMatcher<T> {
    @Nullable
    private final T compareTo;
    @Nonnull
    private final Map<Object, Long> itemToSize = Collections.synchronizedMap(new WeakHashMap(1, 1.0f));

    @Nonnull
    public static <T> Matcher<T> hasSameSizeAs(@Nullable T compareTo) {
        return new HasSameSizeAs<T>(compareTo);
    }

    @Nonnull
    public static <T> Matcher<T> hasSameLengthAs(@Nullable T compareTo) {
        return HasSameSizeAs.hasSameSizeAs(compareTo);
    }

    protected HasSameSizeAs(@Nullable T compareTo) {
        this.compareTo = compareTo;
    }

    public boolean matches(@Nullable Object item) {
        long expectedSize;
        long actualSize = this.itemToSize.computeIfAbsent(item, SizeUtils::sizeOf);
        return actualSize == (expectedSize = this.itemToSize.computeIfAbsent(this.compareTo(), SizeUtils::sizeOf).longValue());
    }

    public void describeTo(@Nonnull Description description) {
        description.appendText("has size of ").appendValue((Object)this.itemToSize.computeIfAbsent(this.compareTo(), SizeUtils::sizeOf)).appendText(" - same as ").appendValue(this.compareTo());
    }

    public void describeMismatch(@Nullable Object item, @Nonnull Description description) {
        description.appendText("was ").appendValue((Object)this.itemToSize.get(item)).appendText(" with content ").appendValue(item);
    }

    @Nullable
    protected T compareTo() {
        return this.compareTo;
    }
}

