/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.unittest.utils.matchers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;

public class CombinedMappingMatcher<V, T>
extends BaseMatcher<V> {
    @Nonnegative
    protected static final int MAXIMUM_MISMATCHES_TO_REPORT = 10;
    @Nonnull
    private final Function<V, Stream<T>> mapper;
    @Nonnull
    private final Iterable<? extends Matcher<T>> matchers;
    @Nonnull
    private final StreamMatcher<T> streamMatcher;
    @Nonnull
    private final String description;

    public CombinedMappingMatcher(@Nonnull Function<V, Stream<T>> mapper, @Nonnull Iterable<? extends Matcher<T>> matchers, @Nonnull StreamMatcher<T> streamMatcher, @Nonnull String description) {
        this.mapper = mapper;
        this.matchers = matchers;
        this.streamMatcher = streamMatcher;
        this.description = description;
    }

    @SafeVarargs
    @Nonnull
    public static <T> Iterable<Matcher<T>> collectMatchers(@Nonnull Matcher<T> firstMatcher, Matcher<T> ... otherMatchers) {
        ArrayList<Matcher<T>> result = new ArrayList<Matcher<T>>(1 + (otherMatchers != null ? otherMatchers.length : 0));
        result.add(firstMatcher);
        if (otherMatchers != null) {
            Collections.addAll(result, otherMatchers);
        }
        return Collections.unmodifiableList(result);
    }

    public boolean matches(@Nullable Object item) {
        Stream<T> stream;
        if (item == null) {
            return false;
        }
        try {
            stream = this.mapper().apply(item);
        }
        catch (ClassCastException ignored) {
            return false;
        }
        return this.streamMatcher().matches(this.matchers(), stream);
    }

    public void describeMismatch(@Nullable Object item, @Nonnull Description description) {
        Stream<T> stream;
        if (item == null) {
            description.appendText("was ").appendValue(null);
            return;
        }
        try {
            stream = this.mapper().apply(item);
        }
        catch (ClassCastException ignored) {
            description.appendText("was unexpected type ").appendValue(item.getClass());
            return;
        }
        this.describeMismatch(stream, description);
    }

    protected void describeMismatch(@Nonnull Stream<T> items, @Nonnull Description description) {
        AtomicBoolean firstElementPrinted = new AtomicBoolean();
        AtomicLong printedMismatchedElements = new AtomicLong();
        items.forEach(item -> {
            AtomicBoolean firstMatcherPrinted = new AtomicBoolean();
            if (printedMismatchedElements.get() < 10L) {
                for (Matcher<T> matcher : this.matchers()) {
                    if (matcher.matches(item)) continue;
                    if (firstElementPrinted.getAndSet(true)) {
                        description.appendText("\n          ");
                    }
                    if (firstMatcherPrinted.getAndSet(true)) {
                        description.appendText("    and ");
                    } else {
                        description.appendText("for ").appendValue(item).appendText(" ");
                        printedMismatchedElements.incrementAndGet();
                    }
                    description.appendDescriptionOf(matcher).appendText(" ");
                    matcher.describeMismatch(item, description);
                }
            } else if (printedMismatchedElements.get() < 11L) {
                description.appendText("\n          [...]");
                printedMismatchedElements.incrementAndGet();
            }
        });
    }

    public void describeTo(@Nonnull Description description) {
        AtomicBoolean firstMatcherPrinted = new AtomicBoolean();
        this.matchers().forEach(matcher -> {
            if (firstMatcherPrinted.getAndSet(true)) {
                description.appendText("\n              and ");
            } else {
                description.appendText(this.description()).appendText(" ");
            }
            description.appendDescriptionOf((SelfDescribing)matcher);
        });
    }

    @Nonnull
    protected Function<V, Stream<T>> mapper() {
        return this.mapper;
    }

    @Nonnull
    protected Iterable<? extends Matcher<T>> matchers() {
        return this.matchers;
    }

    @Nonnull
    protected StreamMatcher<T> streamMatcher() {
        return this.streamMatcher;
    }

    @Nonnull
    protected String description() {
        return this.description;
    }

    @FunctionalInterface
    public static interface StreamMatcher<T> {
        public boolean matches(@Nonnull Iterable<? extends Matcher<T>> var1, @Nonnull Stream<T> var2);
    }
}

