/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.unittest.utils.matchers;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.echocat.unittest.utils.matchers.CombinedMappingMatcher;
import org.hamcrest.Matcher;

public class ContainsOnlyElementsThat<V, T>
extends CombinedMappingMatcher<V, T> {
    public ContainsOnlyElementsThat(@Nonnull Function<V, Stream<T>> mapper, @Nonnull Iterable<? extends Matcher<T>> matchers) {
        super(mapper, matchers, ContainsOnlyElementsThat.streamMatcherInstance(), "contains only elements that");
    }

    @Nonnull
    protected static <T> CombinedMappingMatcher.StreamMatcher<T> streamMatcherInstance() {
        return ContainsOnlyElementsThat::matches;
    }

    protected static <T> boolean matches(@Nonnull Iterable<? extends Matcher<T>> matchers, @Nonnull Stream<T> items) {
        AtomicBoolean everyItemWasTrue = new AtomicBoolean(true);
        AtomicBoolean hasAtLeastOneItem = new AtomicBoolean(false);
        items.forEach(item -> matchers.forEach(matcher -> {
            hasAtLeastOneItem.set(true);
            if (!matcher.matches(item)) {
                everyItemWasTrue.set(false);
            }
        }));
        return everyItemWasTrue.get() && hasAtLeastOneItem.get();
    }
}

