/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.unittest.utils.matchers;

import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class IsOneOf<T>
extends BaseMatcher<T> {
    @Nonnull
    private final Collection<T> expected;

    @SafeVarargs
    @Nonnull
    public static <T> Matcher<T> isOneOf(T ... expected) {
        return IsOneOf.isOneOf(Arrays.asList(expected));
    }

    @Nonnull
    public static <T> Matcher<T> isOneOf(@Nonnull Collection<T> expected) {
        return new IsOneOf<T>(expected);
    }

    @SafeVarargs
    @Nonnull
    public static <T> Matcher<T> isAnyOf(T ... expected) {
        return IsOneOf.isAnyOf(Arrays.asList(expected));
    }

    @Nonnull
    public static <T> Matcher<T> isAnyOf(@Nonnull Collection<T> expected) {
        return IsOneOf.isOneOf(expected);
    }

    protected IsOneOf(@Nonnull Collection<T> expected) {
        this.expected = expected;
    }

    public boolean matches(@Nullable Object item) {
        return this.expected.contains(item);
    }

    public void describeTo(@Nonnull Description description) {
        description.appendText("is one of").appendText(" [");
        boolean first = true;
        for (T item : this.expected) {
            if (first) {
                first = false;
            } else {
                description.appendText(", ");
            }
            description.appendValue(item);
        }
        description.appendText("]");
    }

    @Nonnull
    protected Collection<T> expected() {
        return this.expected;
    }
}

