/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.unittest.utils.matchers;

import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public class IterableBasedMatcher<V, T extends Iterable<V>>
extends BaseMatcher<T> {
    @Nonnull
    private final Iterable<? extends V> expected;
    @Nonnull
    private final String comparatorDescription;
    @Nonnull
    private final Comparator<V> comparator;

    @Nonnull
    protected static <V> Comparator<V> startsWithComparator() {
        return IterableBasedMatcher::startsWith;
    }

    @Nonnull
    protected static <V> Comparator<V> endsWithComparator() {
        return IterableBasedMatcher::endsWith;
    }

    @Nonnull
    protected static <V> Comparator<V> containsComparator() {
        return IterableBasedMatcher::contains;
    }

    protected IterableBasedMatcher(@Nonnull String comparatorDescription, @Nonnull Comparator<V> comparator, @Nonnull Iterable<? extends V> expected) {
        this.comparatorDescription = comparatorDescription;
        this.comparator = comparator;
        this.expected = expected;
    }

    public boolean matches(@Nullable Object item) {
        if (item instanceof Iterable) {
            return this.comparator.check((Iterable)item, this.expected);
        }
        return false;
    }

    public void describeTo(@Nonnull Description description) {
        description.appendText(this.comparatorDescription).appendText(" [");
        boolean first = true;
        for (V item : this.expected) {
            if (first) {
                first = false;
            } else {
                description.appendText(", ");
            }
            description.appendValue(item);
        }
        description.appendText("]");
    }

    @Nonnull
    protected Iterable<? extends V> expected() {
        return this.expected;
    }

    @Nonnull
    protected String comparatorDescription() {
        return this.comparatorDescription;
    }

    @Nonnull
    protected Comparator<V> comparator() {
        return this.comparator;
    }

    protected static boolean startsWith(@Nonnull Iterable<Object> actual, @Nonnull Iterable<Object> expected) {
        Iterator<Object> ai = actual.iterator();
        Iterator<Object> ei = expected.iterator();
        while (ai.hasNext() && ei.hasNext()) {
            Object eo;
            Object ao = ai.next();
            if (Objects.equals(ao, eo = ei.next())) continue;
            return false;
        }
        return !ei.hasNext();
    }

    protected static boolean endsWith(@Nonnull Iterable<Object> actual, @Nonnull Iterable<Object> expected) {
        Iterator<Object> ai = actual.iterator();
        Iterator<Object> fei = expected.iterator();
        if (!ai.hasNext() && fei.hasNext()) {
            return false;
        }
        if (!fei.hasNext()) {
            return true;
        }
        Object feo = fei.next();
        while (ai.hasNext()) {
            Object fao = ai.next();
            if (!Objects.equals(fao, feo)) continue;
            Iterator<Object> ei = expected.iterator();
            IterableBasedMatcher.skipOne(ei);
            boolean allMatches = IterableBasedMatcher.continueMatchesOn(ai, ei);
            if (ai.hasNext() || ei.hasNext()) continue;
            return allMatches;
        }
        return false;
    }

    protected static boolean contains(@Nonnull Iterable<Object> actual, @Nonnull Iterable<Object> expected) {
        Iterator<Object> ai = actual.iterator();
        Iterator<Object> fei = expected.iterator();
        if (!ai.hasNext() && fei.hasNext()) {
            return false;
        }
        if (!fei.hasNext()) {
            return true;
        }
        Object feo = fei.next();
        while (ai.hasNext()) {
            Object fao = ai.next();
            if (!Objects.equals(fao, feo)) continue;
            Iterator<Object> ei = expected.iterator();
            IterableBasedMatcher.skipOne(ei);
            boolean allMatches = IterableBasedMatcher.continueMatchesOn(ai, ei);
            if (ei.hasNext()) continue;
            return allMatches;
        }
        return false;
    }

    protected static boolean continueMatchesOn(@Nonnull Iterator<Object> ai, @Nonnull Iterator<Object> ei) {
        boolean allMatches = true;
        while (ai.hasNext() && ei.hasNext()) {
            Object eo;
            Object ao = ai.next();
            if (Objects.equals(ao, eo = ei.next())) continue;
            allMatches = false;
            break;
        }
        return allMatches;
    }

    protected static void skipOne(@Nonnull Iterator<?> iterator) {
        if (!iterator.hasNext()) {
            throw new IllegalStateException();
        }
        iterator.next();
    }

    @FunctionalInterface
    public static interface Comparator<V> {
        public boolean check(@Nonnull Iterable<V> var1, @Nonnull Iterable<V> var2);
    }
}

