/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.unittest.utils.matchers;

import java.util.Arrays;
import javax.annotation.Nonnull;
import org.echocat.unittest.utils.matchers.CombinedMappingMatcher;
import org.echocat.unittest.utils.matchers.ContainsAtLeastOneElementThat;
import org.echocat.unittest.utils.matchers.ContainsOnlyElementsThat;
import org.echocat.unittest.utils.matchers.IterableBasedMatcher;
import org.echocat.unittest.utils.utils.StreamUtils;
import org.hamcrest.Matcher;

public final class IterableMatchers {
    @Nonnull
    public static <T> Matcher<Iterable<T>> containsOnlyElementsThat(@Nonnull Iterable<? extends Matcher<T>> matchers) {
        return new ContainsOnlyElementsThat(StreamUtils::toStream, matchers);
    }

    @SafeVarargs
    @Nonnull
    public static <T> Matcher<Iterable<T>> containsOnlyElementsThat(@Nonnull Matcher<T> matcher, Matcher<T> ... otherMatchers) {
        return IterableMatchers.containsOnlyElementsThat(CombinedMappingMatcher.collectMatchers(matcher, otherMatchers));
    }

    @Nonnull
    public static <T> Matcher<Iterable<T>> containsOnlyElements(@Nonnull Iterable<? extends Matcher<T>> matchers) {
        return IterableMatchers.containsOnlyElementsThat(matchers);
    }

    @SafeVarargs
    @Nonnull
    public static <T> Matcher<Iterable<T>> containsOnlyElements(@Nonnull Matcher<T> matcher, Matcher<T> ... otherMatchers) {
        return IterableMatchers.containsOnlyElements(CombinedMappingMatcher.collectMatchers(matcher, otherMatchers));
    }

    @Nonnull
    public static <T> Matcher<Iterable<T>> containsAtLeastOneElementThat(@Nonnull Iterable<? extends Matcher<T>> matchers) {
        return new ContainsAtLeastOneElementThat(StreamUtils::toStream, matchers);
    }

    @SafeVarargs
    @Nonnull
    public static <T> Matcher<Iterable<T>> containsAtLeastOneElementThat(@Nonnull Matcher<T> matcher, Matcher<T> ... otherMatchers) {
        return IterableMatchers.containsAtLeastOneElementThat(CombinedMappingMatcher.collectMatchers(matcher, otherMatchers));
    }

    @Nonnull
    public static <T> Matcher<Iterable<T>> containsAtLeastOneElement(@Nonnull Iterable<? extends Matcher<T>> matchers) {
        return IterableMatchers.containsAtLeastOneElementThat(matchers);
    }

    @SafeVarargs
    @Nonnull
    public static <T> Matcher<Iterable<T>> containsAtLeastOneElement(@Nonnull Matcher<T> matcher, Matcher<T> ... otherMatchers) {
        return IterableMatchers.containsAtLeastOneElement(CombinedMappingMatcher.collectMatchers(matcher, otherMatchers));
    }

    @SafeVarargs
    @Nonnull
    public static <V, T extends Iterable<V>> Matcher<T> startsWith(V ... prefix) {
        return IterableMatchers.startsWith(Arrays.asList(prefix));
    }

    @Nonnull
    public static <V, T extends Iterable<V>> Matcher<T> startsWith(@Nonnull Iterable<? extends V> prefix) {
        return new IterableBasedMatcher("starts with", IterableBasedMatcher.startsWithComparator(), prefix);
    }

    @SafeVarargs
    @Nonnull
    public static <V, T extends Iterable<V>> Matcher<T> endsWith(V ... suffix) {
        return IterableMatchers.endsWith(Arrays.asList(suffix));
    }

    @Nonnull
    public static <V, T extends Iterable<V>> Matcher<T> endsWith(@Nonnull Iterable<? extends V> suffix) {
        return new IterableBasedMatcher("ends with", IterableBasedMatcher.endsWithComparator(), suffix);
    }

    @SafeVarargs
    @Nonnull
    public static <V, T extends Iterable<V>> Matcher<T> contains(V ... what) {
        return IterableMatchers.contains(Arrays.asList(what));
    }

    @Nonnull
    public static <V, T extends Iterable<V>> Matcher<T> contains(@Nonnull Iterable<? extends V> what) {
        return new IterableBasedMatcher("contains", IterableBasedMatcher.containsComparator(), what);
    }
}

