/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.unittest.utils.matchers;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class OptionalBasedMatcher<T>
extends BaseMatcher<Optional<T>> {
    @Nonnull
    private final String baseDescription;
    @Nonnull
    private final BaseChecker<T> baseChecker;
    @Nonnull
    private final Optional<Matcher<T>> contentMatcher;

    @Nonnull
    protected static <T> BaseChecker<T> isPresentBaseChecker() {
        return Optional::isPresent;
    }

    @Nonnull
    protected static <T> BaseChecker<T> isAbsentBaseChecker() {
        return actual -> !actual.isPresent();
    }

    protected OptionalBasedMatcher(@Nonnull String baseDescription, @Nonnull BaseChecker<T> baseChecker, @Nullable Matcher<T> contentMatcher) {
        this.baseDescription = baseDescription;
        this.baseChecker = baseChecker;
        this.contentMatcher = Optional.ofNullable(contentMatcher);
    }

    public boolean matches(@Nullable Object item) {
        if (!(item instanceof Optional)) {
            return false;
        }
        Optional optional = (Optional)item;
        if (!this.baseChecker().check(optional)) {
            return false;
        }
        return this.contentMatcher().map(matcher -> matcher.matches(optional.orElseThrow(() -> new IllegalStateException("The base checker should cover presence of optional value before.")))).orElse(true);
    }

    public void describeTo(@Nonnull Description description) {
        description.appendText(this.baseDescription());
        this.contentMatcher().ifPresent(matcher -> matcher.describeTo(description));
    }

    @Nonnull
    protected String baseDescription() {
        return this.baseDescription;
    }

    @Nonnull
    protected BaseChecker<T> baseChecker() {
        return this.baseChecker;
    }

    @Nonnull
    protected Optional<Matcher<T>> contentMatcher() {
        return this.contentMatcher;
    }

    @FunctionalInterface
    public static interface BaseChecker<T> {
        public boolean check(@Nonnull Optional<T> var1);
    }
}

