/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.unittest.utils.nio;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.Set;
import javax.annotation.Nonnull;
import org.echocat.unittest.utils.nio.WrappedFileSystemProvider;
import org.echocat.unittest.utils.nio.WrappedPath;

public class WrappedFileSystem<T extends WrappedPath>
extends FileSystem {
    @Nonnull
    private final Class<T> wrappedPathType;
    @Nonnull
    private final FileSystem wrapped;

    public WrappedFileSystem(@Nonnull Class<T> wrappedPathType, @Nonnull FileSystem wrapped) {
        this.wrappedPathType = wrappedPathType;
        this.wrapped = wrapped;
    }

    @Nonnull
    public FileSystem wrapped() {
        return this.wrapped;
    }

    @Override
    public FileSystemProvider provider() {
        return new WrappedFileSystemProvider<T>(this.wrappedPathType, this.wrapped().provider());
    }

    @Override
    public void close() throws IOException {
        this.wrapped().close();
    }

    @Override
    public boolean isOpen() {
        return this.wrapped().isOpen();
    }

    @Override
    public boolean isReadOnly() {
        return this.wrapped().isReadOnly();
    }

    @Override
    public String getSeparator() {
        return this.wrapped().getSeparator();
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return this.wrapped().getRootDirectories();
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return this.wrapped().getFileStores();
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return this.wrapped().supportedFileAttributeViews();
    }

    @Override
    public Path getPath(String first, String ... more) {
        return this.wrapped().getPath(first, more);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        return this.wrapped().getPathMatcher(syntaxAndPattern);
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        return this.wrapped().getUserPrincipalLookupService();
    }

    @Override
    public WatchService newWatchService() throws IOException {
        return this.wrapped().newWatchService();
    }
}

