/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.dns;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetSocketAddress;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SimpleResolver;

public class ResolverUtils {
    private static final Method SIMPLE_RESOLVER_GET_ADDRESS_METHOD = ResolverUtils.tryGetSimpleResolverGetAddressMethod();
    private static final Field LOOKUP_RESOLVER_FIELD = ResolverUtils.tryGetLookupResolverField();

    @Nonnull
    public static String toString(@Nullable Resolver resolver) {
        String result = resolver instanceof SimpleResolver ? ResolverUtils.toString((SimpleResolver)resolver) : (resolver instanceof ExtendedResolver ? ResolverUtils.toString((ExtendedResolver)resolver) : (resolver != null ? resolver.toString() : "null"));
        return result;
    }

    @Nonnull
    public static String toString(@Nullable SimpleResolver resolver) {
        InetSocketAddress address = ResolverUtils.tryGetAddressOf(resolver);
        String result = address != null ? address.toString() : (resolver != null ? resolver.toString() : "null");
        return result;
    }

    @Nonnull
    public static String toString(@Nullable ExtendedResolver resolver) {
        StringBuilder result = new StringBuilder();
        if (resolver != null) {
            Resolver[] resolvers = resolver.getResolvers();
            if (resolvers != null && resolvers.length > 0) {
                for (int i = 0; i < resolvers.length; ++i) {
                    if (i > 0) {
                        result.append(',');
                    }
                    result.append(ResolverUtils.toString(resolvers[i]));
                }
            } else {
                result.append("null");
            }
        } else {
            result.append("null");
        }
        return result.toString();
    }

    @Nonnull
    public static String toStringOfResolver(@Nullable Lookup lookup) {
        Resolver resolver = ResolverUtils.findResolverOf(lookup);
        return resolver != null ? ResolverUtils.toString(resolver) : "unknown";
    }

    @Nullable
    public static Resolver findResolverOf(@Nullable Lookup lookup) {
        Resolver resolver = null;
        if (lookup != null && LOOKUP_RESOLVER_FIELD != null) {
            try {
                resolver = (Resolver)LOOKUP_RESOLVER_FIELD.get(lookup);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return resolver;
    }

    @Nullable
    private static InetSocketAddress tryGetAddressOf(@Nullable SimpleResolver resolver) {
        InetSocketAddress result = null;
        if (resolver != null && SIMPLE_RESOLVER_GET_ADDRESS_METHOD != null) {
            try {
                result = (InetSocketAddress)SIMPLE_RESOLVER_GET_ADDRESS_METHOD.invoke((Object)resolver, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return result;
    }

    @Nullable
    private static Method tryGetSimpleResolverGetAddressMethod() {
        Method possibleMethod = ResolverUtils.findPossibleSimpleResolverGetAddressMethod();
        return ResolverUtils.isValidSimpleResolverGetAddressMethod(possibleMethod) ? possibleMethod : null;
    }

    private static boolean isValidSimpleResolverGetAddressMethod(@Nullable Method possibleMethod) {
        int modifiers = possibleMethod != null ? possibleMethod.getModifiers() : -1;
        return possibleMethod != null && !Modifier.isStatic(modifiers) && InetSocketAddress.class.equals(possibleMethod.getReturnType());
    }

    @Nullable
    private static Method findPossibleSimpleResolverGetAddressMethod() {
        Method possibleMethod;
        try {
            possibleMethod = SimpleResolver.class.getDeclaredMethod("getAddress", new Class[0]);
            possibleMethod.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException ignored) {
            possibleMethod = null;
        }
        return possibleMethod;
    }

    @Nullable
    private static Field tryGetLookupResolverField() {
        Field field;
        try {
            field = Lookup.class.getDeclaredField("resolver");
            field.setAccessible(true);
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers) || !Resolver.class.equals(field.getType())) {
                field = null;
            }
        }
        catch (NoSuchFieldException | SecurityException ignored) {
            field = null;
        }
        return field;
    }

    private ResolverUtils() {
    }
}

