/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.dns;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.net.HostService;
import org.echocat.jomon.net.Protocol;
import org.echocat.jomon.net.dns.ResolverUtils;
import org.echocat.jomon.runtime.util.ServiceTemporaryUnavailableException;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Address;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SRVRecord;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TextParseException;

public class SrvDnsEntryEvaluator {
    private Resolver _resolver;

    public SrvDnsEntryEvaluator() {
    }

    public SrvDnsEntryEvaluator(@Nullable Resolver resolver) {
        this();
        this._resolver = resolver;
    }

    @Nonnull
    public String buildQueryFor(@Nonnull String service, @Nonnull Protocol protocol, @Nonnull String host) {
        return "_" + service + "._" + protocol.getName() + "." + host;
    }

    @Nonnull
    public List<HostService> lookup(@Nonnull String service, @Nonnull Protocol protocol, @Nonnull String host) throws NoSuchSrvRecordException, UnknownHostException, SocketException {
        return this.lookup(this.buildQueryFor(service, protocol, host));
    }

    @Nonnull
    public List<HostService> lookup(@Nonnull String query) throws NoSuchSrvRecordException, UnknownHostException, SocketException {
        Lookup lookup = this.createLookupFor(query, 33);
        lookup.run();
        this.checkResult(query, lookup);
        SRVRecord[] records = this.getSrvRecordsOf(lookup);
        ArrayList<HostService> result = new ArrayList<HostService>();
        for (SRVRecord record : records) {
            HostService service = this.toHostService(record);
            if (service == null) continue;
            result.add(service);
        }
        return Collections.unmodifiableList(result);
    }

    @Nullable
    protected HostService toHostService(@Nonnull SRVRecord record) {
        InetSocketAddress address = this.toInetSocketAddress(record);
        return address != null ? new HostService(address, record.getPriority(), record.getWeight(), record.getTTL()) : null;
    }

    @Nullable
    protected InetSocketAddress toInetSocketAddress(@Nonnull SRVRecord record) {
        InetAddress address = this.toInetAddress(record);
        return address != null ? new InetSocketAddress(address, record.getPort()) : null;
    }

    @Nullable
    protected InetAddress toInetAddress(@Nonnull SRVRecord record) {
        InetAddress address;
        String name = record.getTarget().toString();
        try {
            address = Address.getByAddress((String)name);
        }
        catch (UnknownHostException ignored) {
            Record[] records = this.createLookupFor(name, 1).run();
            address = records != null && records.length > 0 ? SrvDnsEntryEvaluator.toInetAddress(name, (ARecord)records[0]) : null;
        }
        return address;
    }

    @Nonnull
    protected static InetAddress toInetAddress(@Nonnull String name, @Nonnull ARecord record) {
        try {
            return InetAddress.getByAddress(name, record.getAddress().getAddress());
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Could not convert " + record + " to address.", e);
        }
    }

    @Nonnull
    protected SRVRecord[] getSrvRecordsOf(@Nonnull Lookup lookup) {
        Record[] records = lookup.getAnswers();
        if (records == null) {
            throw new IllegalStateException("Got no answers for " + lookup + " from remote " + ResolverUtils.toStringOfResolver(lookup) + ".");
        }
        SRVRecord[] srvRecords = new SRVRecord[records.length];
        for (int i = 0; i < records.length; ++i) {
            if (!(records[i] instanceof SRVRecord)) {
                throw new IllegalStateException("Got illegal answers for " + lookup + " from remote " + ResolverUtils.toStringOfResolver(lookup) + ".");
            }
            srvRecords[i] = (SRVRecord)records[i];
        }
        return srvRecords;
    }

    protected void checkResult(@Nonnull String query, @Nonnull Lookup lookup) throws NoSuchSrvRecordException, UnknownHostException, SocketException {
        int result = lookup.getResult();
        if (result == 3) {
            throw new NoSuchSrvRecordException("Could not find srv entry for query '" + query + "' on remote " + ResolverUtils.toStringOfResolver(lookup) + ".");
        }
        if (result == 4) {
            throw new UnknownHostException("Could not find the host that should contain the srv entry for query '" + query + "' on remote " + ResolverUtils.toStringOfResolver(lookup) + ".");
        }
        if (result == 2) {
            throw new ServiceTemporaryUnavailableException("Could not get information from remote " + ResolverUtils.toStringOfResolver(lookup) + ".");
        }
        if (result != 0) {
            throw new RuntimeException("Could not get information from remote " + ResolverUtils.toStringOfResolver(lookup) + ". Got: " + lookup.getErrorString());
        }
    }

    public void setResolver(Resolver resolver) {
        this._resolver = resolver;
    }

    public void setResolverByHostName(String resolverHostName) throws UnknownHostException {
        this._resolver = resolverHostName != null ? new SimpleResolver(resolverHostName) : null;
    }

    @Nonnull
    protected Lookup createLookupFor(@Nonnull String query, @Nonnegative int type) {
        Lookup lookup;
        try {
            lookup = new Lookup(query, type);
        }
        catch (TextParseException e) {
            throw new IllegalArgumentException("Could not parse query: " + query, e);
        }
        Resolver resolver = this._resolver;
        lookup.setResolver(resolver != null ? resolver : Lookup.getDefaultResolver());
        lookup.setCache(null);
        return lookup;
    }

    public static class NoSuchSrvRecordException
    extends UnknownHostException {
        public NoSuchSrvRecordException(String message) {
            super(message);
        }
    }
}

