/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import org.apache.commons.collections15.MultiMap;
import org.echocat.jomon.runtime.iterators.CloseableIterator;
import org.echocat.jomon.runtime.util.ResourceUtils;

public class CollectionUtils {
    public static <K, V> Map<K, V> asMap(Object ... a) {
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
        if (a != null) {
            int length = a.length;
            if (length % 2 == 1) {
                throw new IllegalArgumentException("You must provide an even number of arguments.");
            }
            for (int i = 0; i < length; i += 2) {
                result.put(a[i], a[i + 1]);
            }
        }
        return result;
    }

    public static boolean isNotEmpty(@Nullable Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    public static boolean isNotEmpty(@Nullable Iterable<?> iterable) {
        return iterable != null && CollectionUtils.isNotEmpty(iterable.iterator());
    }

    public static boolean isNotEmpty(@Nullable Iterator<?> iterator) {
        return iterator != null && iterator.hasNext();
    }

    public static boolean isNotEmpty(@Nullable Map<?, ?> map) {
        return map != null && !map.isEmpty();
    }

    public static boolean isNotEmpty(@Nullable MultiMap<?, ?> map) {
        return map != null && !map.isEmpty();
    }

    public static boolean isEmpty(@Nullable Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(@Nullable Iterable<?> iterable) {
        return iterable == null || CollectionUtils.isEmpty(iterable.iterator());
    }

    public static boolean isEmpty(@Nullable Iterator<?> iterator) {
        return iterator == null || !iterator.hasNext();
    }

    public static boolean isEmpty(@Nullable Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isEmpty(@Nullable MultiMap<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static <T> void addAll(@Nonnull Collection<T> to, @Nullable T[] elements) {
        if (elements != null) {
            Collections.addAll(to, elements);
        }
    }

    public static <T> void addAll(@Nonnull Collection<T> to, @Nullable Iterable<T> elements) {
        if (elements != null) {
            CollectionUtils.addAll(to, elements.iterator());
        }
    }

    public static <T> void addAll(@Nonnull Collection<T> to, @Nullable Iterator<T> elements) {
        if (elements != null) {
            while (elements.hasNext()) {
                to.add(elements.next());
            }
        }
    }

    @Nonnull
    public static <T> List<T> asList(T ... objects) {
        ArrayList result;
        if (objects == null) {
            result = new ArrayList();
        } else {
            int initialCapacity = Math.max(16, (objects.length + 2) / 3 * 4);
            result = new ArrayList(initialCapacity);
            result.addAll(new ArrayWrapper(objects));
        }
        return result;
    }

    @Nonnull
    public static <T> List<T> asImmutableList(T ... objects) {
        return Collections.unmodifiableList(CollectionUtils.asList(objects));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static <T> List<T> asList(@Nullable Iterator<T> iterator) {
        ArrayList<T> result = new ArrayList<T>();
        try {
            if (iterator != null) {
                while (iterator.hasNext()) {
                    result.add(iterator.next());
                }
            }
        }
        finally {
            if (iterator instanceof AutoCloseable) {
                ResourceUtils.closeQuietly((AutoCloseable)((Object)iterator));
            }
        }
        return result;
    }

    @Nonnull
    public static <T> List<T> asImmutableList(@Nullable Iterator<T> iterator) {
        return Collections.unmodifiableList(CollectionUtils.asList(iterator));
    }

    @Nonnull
    public static <T> List<T> asList(@Nullable Iterable<T> in) {
        ArrayList result;
        if (in instanceof List) {
            result = (ArrayList)in;
        } else if (in instanceof Collection) {
            result = new ArrayList((Collection)in);
        } else {
            result = new ArrayList();
            CollectionUtils.addAll(result, in);
        }
        return result;
    }

    @Nonnull
    public static <T> List<T> asImmutableList(@Nullable Iterable<T> in) {
        return Collections.unmodifiableList(CollectionUtils.asList(in));
    }

    @Nonnull
    public static <T> Set<T> asSet(T ... objects) {
        LinkedHashSet result;
        if (objects == null) {
            result = new LinkedHashSet();
        } else {
            int initialCapacity = Math.max(16, (objects.length + 2) / 3 * 4);
            result = new LinkedHashSet(initialCapacity);
            result.addAll(new ArrayWrapper(objects));
        }
        return result;
    }

    @Nonnull
    public static <T> Set<T> asImmutableSet(T ... objects) {
        return Collections.unmodifiableSet(CollectionUtils.asSet(objects));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static <T> Set<T> asSet(@Nullable Iterator<T> iterator) {
        LinkedHashSet<T> result = new LinkedHashSet<T>();
        try {
            if (iterator != null) {
                while (iterator.hasNext()) {
                    result.add(iterator.next());
                }
            }
        }
        finally {
            if (iterator instanceof AutoCloseable) {
                ResourceUtils.closeQuietly((AutoCloseable)((Object)iterator));
            }
        }
        return result;
    }

    @Nonnull
    public static <T> Set<T> asImmutableSet(@Nullable Iterator<T> iterator) {
        return Collections.unmodifiableSet(CollectionUtils.asSet(iterator));
    }

    @Nonnull
    public static <T> Set<T> asSet(@Nullable Iterable<T> in) {
        LinkedHashSet result;
        if (in instanceof Set) {
            result = (LinkedHashSet)in;
        } else if (in instanceof Collection) {
            result = new LinkedHashSet((Collection)in);
        } else {
            result = new LinkedHashSet();
            CollectionUtils.addAll(result, in);
        }
        return result;
    }

    @Nonnull
    public static <T> Set<T> asImmutableSet(@Nullable Iterable<T> in) {
        return Collections.unmodifiableSet(CollectionUtils.asSet(in));
    }

    @Nonnull
    public static <T> CloseableIterator<T> asSingletonIterator(final @Nullable T element) {
        return new CloseableIterator<T>(){
            private boolean _elementFetched;

            @Override
            public boolean hasNext() {
                return !this._elementFetched;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this._elementFetched = true;
                return element;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
            }
        };
    }

    @Nonnull
    public static <T> CloseableIterator<T> asCloseableIterator(final @Nullable Iterator<T> iterator) {
        CloseableIterator result = iterator instanceof CloseableIterator ? (CloseableIterator)iterator : (iterator != null ? new CloseableIterator<T>(){

            @Override
            public void close() {
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        } : CollectionUtils.emptyIterator());
        return result;
    }

    @SafeVarargs
    @Nonnull
    public static <T> CloseableIterator<T> asIterator(T ... elements) {
        int length;
        CloseableIterator<T> result = elements != null ? ((length = elements.length) == 0 ? CollectionUtils.emptyIterator() : (length == 1 ? CollectionUtils.asSingletonIterator(elements[0]) : CollectionUtils.asIterator(Arrays.asList(elements)))) : CollectionUtils.emptyIterator();
        return result;
    }

    @Nonnull
    public static <T> CloseableIterator<T> asIterator(@Nullable Iterable<T> elements) {
        Iterator<T> iterator;
        CloseableIterator<T> result = elements != null ? ((iterator = elements.iterator()).hasNext() ? CollectionUtils.asCloseableIterator(iterator) : CollectionUtils.emptyIterator()) : CollectionUtils.emptyIterator();
        return result;
    }

    @Nonnull
    public static <T> CloseableIterator<T> emptyIterator() {
        return new CloseableIterator<T>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public T next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
            }
        };
    }

    public static <T> boolean oneApplies(@Nullable @WillClose Iterable<T> elements, @Nullable T predicate) {
        return elements != null && CollectionUtils.oneApplies(elements, Predicates.equalTo(predicate));
    }

    public static <T> boolean oneApplies(@Nullable @WillClose Iterable<T> elements, @Nonnull Predicate<T> predicate) {
        return elements != null && CollectionUtils.oneApplies(elements.iterator(), predicate);
    }

    public static <T> boolean oneApplies(@Nullable @WillClose Iterable<T> elements, final @Nullable Collection<T> predicate) {
        return CollectionUtils.oneApplies(elements, new Predicate<T>(){

            public boolean apply(@Nullable T input) {
                return predicate == null || predicate.contains(input);
            }
        });
    }

    public static <T> boolean oneApplies(@Nullable @WillClose Iterator<T> elements, @Nonnull T predicate) {
        return elements != null && CollectionUtils.oneApplies(elements, Predicates.equalTo(predicate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> boolean oneApplies(@Nullable @WillClose Iterator<T> elements, @Nonnull Predicate<T> predicate) {
        boolean result = false;
        if (elements != null) {
            try {
                while (elements.hasNext() && !result) {
                    result = predicate.apply(elements.next());
                }
            }
            finally {
                if (elements instanceof AutoCloseable) {
                    ResourceUtils.closeQuietly((AutoCloseable)((Object)elements));
                }
            }
        }
        return result;
    }

    @Nonnegative
    public static <T> long countElementsOf(@Nullable Iterable<T> elements) {
        return CollectionUtils.countElementsOf(elements, null);
    }

    @Nonnegative
    public static <T> long countElementsOf(@Nullable Iterable<T> elements, @Nullable Predicate<T> matches) {
        return elements instanceof Collection && matches == null ? (long)((Collection)elements).size() : CollectionUtils.countElementsOf(elements.iterator(), matches);
    }

    @Nonnegative
    public static <T> long countElementsOf(@Nullable Iterator<T> iterator) {
        return CollectionUtils.countElementsOf(iterator, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnegative
    public static <T> long countElementsOf(@Nullable Iterator<T> iterator, @Nullable Predicate<T> matches) {
        long count = 0L;
        try {
            if (iterator != null) {
                while (iterator.hasNext()) {
                    T what = iterator.next();
                    if (matches != null && !matches.apply(what)) continue;
                    ++count;
                }
            }
        }
        finally {
            if (iterator instanceof AutoCloseable) {
                ResourceUtils.closeQuietly((AutoCloseable)((Object)iterator));
            }
        }
        return count;
    }

    @Nullable
    public static <T> T findFirstOf(@Nullable Iterable<T> elements) {
        return elements != null ? (T)CollectionUtils.findFirstOf(elements.iterator()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static <T> T findFirstOf(@Nullable Iterator<T> iterator) {
        T firstElement = null;
        try {
            if (iterator != null && iterator.hasNext()) {
                firstElement = iterator.next();
            }
        }
        finally {
            if (iterator instanceof AutoCloseable) {
                ResourceUtils.closeQuietly((AutoCloseable)((Object)iterator));
            }
        }
        return firstElement;
    }

    @Nonnegative
    public static <T> long removeAllOf(@Nullable Iterable<T> elements) {
        return CollectionUtils.removeAllOf(elements, null);
    }

    @Nonnegative
    public static <T> long removeAllOf(@Nullable Iterable<T> elements, @Nullable Predicate<T> matching) {
        return CollectionUtils.removeAllOf(elements.iterator(), matching);
    }

    @Nonnegative
    public static <T> long removeAllOf(@Nullable Iterator<T> iterator) {
        return CollectionUtils.removeAllOf(iterator, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnegative
    public static <T> long removeAllOf(@Nullable Iterator<T> iterator, @Nullable Predicate<T> matching) {
        long removed = 0L;
        try {
            if (iterator != null) {
                while (iterator.hasNext()) {
                    T what = iterator.next();
                    if (matching != null && !matching.apply(what)) continue;
                    iterator.remove();
                    ++removed;
                }
            }
        }
        finally {
            if (iterator instanceof AutoCloseable) {
                ResourceUtils.closeQuietly((AutoCloseable)((Object)iterator));
            }
        }
        return removed;
    }

    private CollectionUtils() {
    }

    private static class ArrayWrapper<E>
    extends AbstractList<E> {
        private final E[] _wrappedArray;

        private ArrayWrapper(E[] arrayToWrap) {
            this._wrappedArray = arrayToWrap;
        }

        @Override
        public E get(int index) {
            return this._wrappedArray[index];
        }

        @Override
        public int size() {
            return this._wrappedArray.length;
        }

        @Override
        public Object[] toArray() {
            return this._wrappedArray;
        }
    }
}

