/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime;

import java.io.IOException;
import java.io.ObjectInput;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
@Immutable
public class ImmutableMimeType
extends MimeType {
    public static final ImmutableMimeType TEXT_HTML = ImmutableMimeType.immutableMimeType("text/html");
    public static final ImmutableMimeType TEXT_PLAIN = ImmutableMimeType.immutableMimeType("text/plain");
    public static final ImmutableMimeType APPLICATION_OCTET_STREAM = ImmutableMimeType.immutableMimeType("application/octet-stream");

    @Nonnull
    public static Set<ImmutableMimeType> immutableMimeTypes(String ... rawDatas) throws IllegalArgumentException {
        LinkedHashSet<ImmutableMimeType> result = new LinkedHashSet<ImmutableMimeType>();
        if (rawDatas != null) {
            for (String rawData : rawDatas) {
                result.add(ImmutableMimeType.immutableMimeType(rawData));
            }
        }
        return Collections.unmodifiableSet(result);
    }

    @Nonnull
    public static Set<ImmutableMimeType> immutableMimeTypes(@Nullable Iterable<String> rawDatas) throws IllegalArgumentException {
        LinkedHashSet<ImmutableMimeType> result = new LinkedHashSet<ImmutableMimeType>();
        if (rawDatas != null) {
            for (String rawData : rawDatas) {
                result.add(ImmutableMimeType.immutableMimeType(rawData));
            }
        }
        return Collections.unmodifiableSet(result);
    }

    @Nonnull
    public static ImmutableMimeType immutableMimeType(@Nonnull String rawData) throws IllegalArgumentException {
        try {
            return new ImmutableMimeType(rawData);
        }
        catch (MimeTypeParseException e) {
            throw new IllegalArgumentException(rawData, e);
        }
    }

    public ImmutableMimeType(@Nonnull String rawData) throws MimeTypeParseException {
        super(rawData);
    }

    public boolean equals(Object o) {
        boolean result = this == o ? true : (!(o instanceof MimeType) ? false : this.match((MimeType)o));
        return result;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Nonnull
    public MimeType createModifiableCopy() {
        try {
            return new MimeType(this.toString());
        }
        catch (MimeTypeParseException e) {
            throw new RuntimeException("Could not create a copy of my own (already parsed) rawData?", e);
        }
    }

    public void setSubType(String sub) throws MimeTypeParseException {
        throw new UnsupportedOperationException();
    }

    public void setPrimaryType(String primary) throws MimeTypeParseException {
        throw new UnsupportedOperationException();
    }

    public void setParameter(String name, String value) {
        throw new UnsupportedOperationException();
    }

    public void removeParameter(String name) {
        throw new UnsupportedOperationException();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException();
    }
}

