/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime;

import java.net.InetAddress;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeInformation {
    private static final Logger LOG = LoggerFactory.getLogger(RuntimeInformation.class);
    @Nullable
    private final InetAddress _host = this.resolveHost();
    @Nullable
    private final String _hostName = this.resolveHostNameFor(this._host);
    @Nullable
    private final String _shortHostName = this.resolveShortHostNameFor(this._hostName);

    @Nullable
    protected InetAddress resolveHost() {
        InetAddress result;
        try {
            result = InetAddress.getLocalHost();
        }
        catch (Exception e) {
            result = null;
            LOG.warn("Could not resolve local host.", (Throwable)e);
        }
        return result;
    }

    @Nullable
    protected String resolveHostNameFor(@Nullable InetAddress host) {
        String result;
        try {
            result = host.getCanonicalHostName();
        }
        catch (Exception e) {
            result = null;
            LOG.warn("Could not resolve host name..", (Throwable)e);
        }
        return result;
    }

    @Nullable
    protected String resolveShortHostNameFor(@Nullable String hostName) {
        int firstDot;
        String result = hostName != null ? ((firstDot = hostName.indexOf(46)) > 0 && firstDot + 1 < hostName.length() ? hostName.substring(0, firstDot) : hostName) : null;
        return result;
    }

    @Nullable
    public InetAddress getHost() {
        return this._host;
    }

    @Nullable
    public String getShortHostName() {
        return this._shortHostName;
    }

    @Nullable
    public String getHostName() {
        return this._hostName;
    }
}

