/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.concurrent;

import java.lang.management.ManagementFactory;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.echocat.jomon.runtime.concurrent.MBeanDaemonWrapper;
import org.echocat.jomon.runtime.util.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Daemon
implements AutoCloseable {
    private static final Random RANDOM = new Random();
    private static final Logger LOG = LoggerFactory.getLogger(Daemon.class);
    private static final MBeanServer M_BEAN_SERVER = ManagementFactory.getPlatformMBeanServer();
    private final AtomicLong _overallExecutionDurationInMillis = new AtomicLong();
    private final AtomicLong _overallExecutionCount = new AtomicLong();
    private final AtomicReference<Duration> _lastExecutionDuration = new AtomicReference();
    private final AtomicReference<Date> _nextExecution = new AtomicReference();
    private final AtomicReference<Date> _lastExecution = new AtomicReference();
    private final AtomicInteger _runningInstances = new AtomicInteger();
    private final Runnable _task;
    private Duration _startDelay = new Duration("0");
    private Duration _minStartDelay;
    private Duration _interval = new Duration("1ms");
    private boolean _initiallyActive = true;
    private volatile Thread _thread;

    public Daemon(@Nonnull Runnable task) {
        this._task = task;
    }

    @Nonnull
    public Duration getStartDelay() {
        return this._startDelay;
    }

    public void setStartDelay(@Nonnull Duration startDelay) {
        this._startDelay = startDelay;
    }

    @Nullable
    public Duration getMinStartDelay() {
        return this._minStartDelay;
    }

    public void setMinStartDelay(@Nullable Duration minStartDelay) {
        this._minStartDelay = minStartDelay;
    }

    @Nonnull
    public Duration getInterval() {
        return this._interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInterval(@Nonnull Duration interval) {
        this._interval = interval;
        Daemon daemon = this;
        synchronized (daemon) {
            if (this.isActive()) {
                this.setActive(false);
                this.setActive(true);
            }
        }
    }

    public boolean isInitiallyActive() {
        return this._initiallyActive;
    }

    public void setInitiallyActive(boolean initiallyActive) {
        this._initiallyActive = initiallyActive;
    }

    @PostConstruct
    public void init() throws Exception {
        this._lastExecutionDuration.set(null);
        this._overallExecutionCount.set(0L);
        this._overallExecutionDurationInMillis.set(0L);
        this._lastExecution.set(null);
        try {
            ObjectName objectName = this.createObjectName();
            M_BEAN_SERVER.registerMBean(new MBeanDaemonWrapper(this), objectName);
        }
        catch (Exception e) {
            LOG.warn("Could not register " + this._task + " in JMX. This daemon will be available but is not manageable over JMX.", (Throwable)e);
        }
        if (this._initiallyActive) {
            this.setActive(true);
        }
    }

    @Nonnull
    protected ObjectName createObjectName() throws MalformedObjectNameException {
        return new ObjectName(Daemon.class.getPackage().getName() + ":type=" + Daemon.class.getSimpleName() + ",name=" + this._task.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreDestroy
    public void close() {
        try {
            this.setActive(false);
        }
        finally {
            try {
                ObjectName objectName = this.createObjectName();
                M_BEAN_SERVER.unregisterMBean(objectName);
            }
            catch (Exception e) {
                LOG.warn("Could not unregister " + this._task + " in JMX. This daemon will be destroy but is still visitable over JMX.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(boolean active) {
        if (active) {
            Daemon daemon = this;
            synchronized (daemon) {
                if (this._thread == null) {
                    this._thread = new Executor(this.getTargetStartDelayInMillis(), this._interval);
                    this._thread.start();
                }
            }
        }
        Daemon daemon = this;
        synchronized (daemon) {
            block15: {
                if (this._thread != null) {
                    try {
                        Thread thread = this._thread;
                        thread.interrupt();
                        if (thread == Thread.currentThread()) break block15;
                        try {
                            while (thread.isAlive()) {
                                thread.join(TimeUnit.SECONDS.toMillis(10L));
                                if (!thread.isAlive()) continue;
                                LOG.info("Still wait for termination of task '" + this._task + "'...");
                            }
                        }
                        catch (InterruptedException ignored) {
                            Thread.currentThread().interrupt();
                            LOG.debug("Could not wait for termination of '" + this._task + "'. This thread was interrupted.");
                        }
                    }
                    finally {
                        this._thread = null;
                        this._nextExecution.set(null);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        Daemon daemon = this;
        synchronized (daemon) {
            return this._thread != null;
        }
    }

    public boolean isRunning() {
        return this._runningInstances.get() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long startTimeInMillis = System.currentTimeMillis();
        this._runningInstances.incrementAndGet();
        try {
            this._task.run();
        }
        finally {
            long executionTimeInMillis = System.currentTimeMillis() - startTimeInMillis;
            this._overallExecutionDurationInMillis.addAndGet(executionTimeInMillis);
            this._overallExecutionCount.incrementAndGet();
            this._lastExecution.set(new Date());
            this._lastExecutionDuration.set(new Duration(executionTimeInMillis));
            this._runningInstances.decrementAndGet();
        }
    }

    @Nullable
    protected Duration getTargetStartDelayInMillis() {
        Duration result;
        Duration startDelayInMillis = this._startDelay;
        if (this._minStartDelay == null) {
            result = startDelayInMillis;
        } else {
            long n = startDelayInMillis.toMilliSeconds() - this._minStartDelay.toMilliSeconds() + 1L;
            long plainValue = this.nextPositiveValue() % n;
            result = this._minStartDelay.plus(plainValue);
        }
        return result;
    }

    @Nonnegative
    private long nextPositiveValue() {
        long result;
        while ((result = RANDOM.nextLong()) < 0L) {
        }
        return result;
    }

    @Nullable
    public Date getNextExecution() {
        return this._nextExecution.get();
    }

    @Nullable
    public Date getLastExecution() {
        return this._lastExecution.get();
    }

    @Nullable
    public Duration getLastExecutionDuration() {
        return this._lastExecutionDuration.get();
    }

    @Nonnull
    public Duration getOverallExecutionDuration() {
        return new Duration(this._overallExecutionDurationInMillis.get());
    }

    @Nonnegative
    public long getOverallExecutionCount() {
        return this._overallExecutionCount.get();
    }

    @Nonnull
    Runnable getTask() {
        return this._task;
    }

    protected class Executor
    extends Thread {
        private final Duration _initialDelay;
        private final Duration _delayBetweenEachRun;

        public Executor(@Nonnull Duration initialDelay, Duration delayBetweenEachRun) {
            super(Daemon.this._task.toString());
            this._initialDelay = initialDelay;
            this._delayBetweenEachRun = delayBetweenEachRun;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this._initialDelay != null) {
                    Daemon.this._nextExecution.set(new Date(System.currentTimeMillis() + this._initialDelay.toMilliSeconds()));
                    this._initialDelay.sleep();
                }
            }
            catch (InterruptedException ignored) {
                Executor.currentThread().interrupt();
            }
            finally {
                Daemon.this._nextExecution.set(null);
            }
            while (!Executor.currentThread().isInterrupted()) {
                boolean success = false;
                try {
                    Daemon.this.run();
                    Daemon.this._nextExecution.set(new Date(System.currentTimeMillis() + this._delayBetweenEachRun.toMilliSeconds()));
                    this._delayBetweenEachRun.sleep();
                    success = true;
                }
                catch (InterruptedException ignored) {
                    Executor.currentThread().interrupt();
                }
                catch (Throwable e) {
                    LOG.error("Task " + Daemon.this._task + " failed with an error. This daemon will now stop and this task will not be executed again.", e);
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                    Executor.currentThread().interrupt();
                }
                finally {
                    Daemon.this._nextExecution.set(null);
                    if (success) continue;
                    Daemon.this._thread = null;
                }
            }
        }
    }
}

