/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.concurrent;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import org.echocat.jomon.runtime.concurrent.Daemon;
import org.echocat.jomon.runtime.util.Duration;

public class MBeanDaemonWrapper
implements DynamicMBean {
    private final Daemon _delegate;
    private final Runnable _task;
    private final Map<String, PropertyDescriptor> _propertyNameToDescriptor;

    public MBeanDaemonWrapper(@Nonnull Daemon delegate) {
        this._delegate = delegate;
        this._task = delegate.getTask();
        this._propertyNameToDescriptor = this.getPropertyNameToDescriptorFor(this._task.getClass());
    }

    @Nonnull
    protected Map<String, PropertyDescriptor> getPropertyNameToDescriptorFor(@Nonnull Class<?> clazz) {
        PropertyDescriptor[] propertyDescriptors;
        BeanInfo beanInfo;
        HashMap<String, PropertyDescriptor> propertyNameToDescriptor = new HashMap<String, PropertyDescriptor>();
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Could not load beanInfo of " + clazz.getName() + ".", e);
        }
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
            propertyNameToDescriptor.put(propertyDescriptor.getName(), propertyDescriptor);
        }
        propertyNameToDescriptor.remove("class");
        return propertyNameToDescriptor;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Object result;
        if ("active".equals(attribute)) {
            result = this._delegate.isActive();
        } else if ("interval".equals(attribute)) {
            result = this._delegate.getInterval().toPattern();
        } else if ("running".equals(attribute)) {
            result = this._delegate.isRunning();
        } else if ("nextExecution".equals(attribute)) {
            result = this._delegate.getNextExecution();
        } else if ("lastExecution".equals(attribute)) {
            result = this._delegate.getLastExecution();
        } else if ("lastExecutionDuration".equals(attribute)) {
            result = this._delegate.getLastExecutionDuration() != null ? this._delegate.getLastExecutionDuration().toPattern() : null;
        } else if ("overallExecutionDuration".equals(attribute)) {
            result = this._delegate.getOverallExecutionDuration().toPattern();
        } else if ("overallExecutionCount".equals(attribute)) {
            result = this._delegate.getOverallExecutionCount();
        } else {
            PropertyDescriptor descriptor = this._propertyNameToDescriptor.get(attribute);
            if (descriptor != null && descriptor.getReadMethod() != null) {
                Method readMethod = descriptor.getReadMethod();
                try {
                    Object value = readMethod.invoke((Object)this._task, new Object[0]);
                    if (value == null || this.isTransportableType(value.getClass())) {
                        result = value;
                    }
                    result = value.toString();
                }
                catch (Exception e) {
                    throw new ReflectionException(e);
                }
            } else {
                throw new AttributeNotFoundException(attribute);
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Object targetValue;
        Object value = attribute.getValue();
        if ("active".equals(attribute.getName())) {
            if (!(value instanceof Boolean)) throw new InvalidAttributeValueException();
            this._delegate.setActive((Boolean)value);
            return;
        }
        if ("interval".equals(attribute.getName())) {
            if (!(value instanceof String)) throw new InvalidAttributeValueException();
            this._delegate.setInterval(new Duration(value.toString()));
            return;
        }
        PropertyDescriptor descriptor = this._propertyNameToDescriptor.get(attribute.getName());
        if (descriptor == null || descriptor.getWriteMethod() == null) throw new AttributeNotFoundException(attribute.getName());
        if (value == null || this.isTransportableType(descriptor.getPropertyType())) {
            targetValue = value;
        } else {
            if (!(value instanceof String)) throw new InvalidAttributeValueException();
            targetValue = this.fromString((String)value, descriptor.getPropertyType());
        }
        Method writeMethod = descriptor.getWriteMethod();
        try {
            writeMethod.invoke((Object)this._task, targetValue);
            return;
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
    }

    @Nonnull
    protected Object fromString(@Nonnull String value, @Nonnull Class<?> propertyType) throws ReflectionException {
        Constructor<?> constructor;
        try {
            constructor = propertyType.getConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException(e, "Could not find a constructor of " + propertyType.getName() + " to create a instance of it with: " + value);
        }
        try {
            return constructor.newInstance(value);
        }
        catch (Exception e) {
            throw new ReflectionException(e, "Could not create a new instance of " + propertyType.getName() + " with: " + value);
        }
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (!"run".equals(actionName)) {
            throw new UnsupportedOperationException("Unknown method '" + actionName + "'.");
        }
        this._delegate.run();
        return null;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        ArrayList<MBeanAttributeInfo> attributes = new ArrayList<MBeanAttributeInfo>();
        attributes.add(new MBeanAttributeInfo("interval", String.class.getName(), null, true, true, false));
        attributes.add(new MBeanAttributeInfo("active", Boolean.class.getName(), null, true, true, true));
        attributes.add(new MBeanAttributeInfo("running", Boolean.class.getName(), null, true, false, true));
        attributes.add(new MBeanAttributeInfo("nextExecution", Date.class.getName(), null, true, false, false));
        attributes.add(new MBeanAttributeInfo("lastExecution", Date.class.getName(), null, true, false, false));
        attributes.add(new MBeanAttributeInfo("lastExecutionDuration", String.class.getName(), null, true, false, false));
        attributes.add(new MBeanAttributeInfo("overallExecutionDuration", String.class.getName(), null, true, false, false));
        attributes.add(new MBeanAttributeInfo("overallExecutionCount", Long.class.getName(), null, true, false, false));
        for (PropertyDescriptor descriptor : this._propertyNameToDescriptor.values()) {
            Method readMethod = descriptor.getReadMethod();
            Method writeMethod = descriptor.getWriteMethod();
            if (readMethod == null && writeMethod == null) continue;
            Class<?> propertyType = descriptor.getPropertyType();
            Class<Object> targetPropertyType = this.isTransportableType(propertyType) ? propertyType : String.class;
            attributes.add(new MBeanAttributeInfo(descriptor.getName(), targetPropertyType.getName(), descriptor.getShortDescription(), readMethod != null, writeMethod != null, Boolean.class.isAssignableFrom(targetPropertyType)));
        }
        return new MBeanInfo(this._delegate.getClass().getName(), null, attributes.toArray(new MBeanAttributeInfo[attributes.size()]), null, new MBeanOperationInfo[]{new MBeanOperationInfo("run", null, new MBeanParameterInfo[0], "void", 1)}, null);
    }

    protected boolean isTransportableType(Class<?> type) {
        return String.class.isAssignableFrom(type) || Double.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type) || Long.class.isAssignableFrom(type) || Integer.class.isAssignableFrom(type) || Short.class.isAssignableFrom(type) || Character.class.isAssignableFrom(type) || Byte.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type);
    }
}

