/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.concurrent;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.runtime.annotations.Excluding;
import org.echocat.jomon.runtime.annotations.Including;
import org.echocat.jomon.runtime.concurrent.BaseRetryingStrategy;
import org.echocat.jomon.runtime.concurrent.RetryingStatus;
import org.echocat.jomon.runtime.numbers.IntegerGenerator;
import org.echocat.jomon.runtime.numbers.IntegerRangeRequirement;
import org.echocat.jomon.runtime.numbers.NumberRequirement;
import org.echocat.jomon.runtime.util.DurationGenerator;
import org.echocat.jomon.runtime.util.DurationRangeRequirement;

@ThreadSafe
public class RetryForSpecifiedCountStrategy<T>
extends BaseRetryingStrategy<T, RetryForSpecifiedCountStrategy<T>> {
    private int _maxNumberOfRetries;

    @Nonnull
    public static <T> RetryForSpecifiedCountStrategy<T> retryForSpecifiedCountOf(@Nonnegative int maxNumberOfRetries) {
        return new RetryForSpecifiedCountStrategy<T>(maxNumberOfRetries);
    }

    public RetryForSpecifiedCountStrategy(@Nonnegative int maxNumberOfRetries) {
        super(new DurationRangeRequirement("10ms", "5s"));
        this._maxNumberOfRetries = maxNumberOfRetries;
    }

    public RetryForSpecifiedCountStrategy() {
        this(5);
    }

    @Nonnull
    public RetryForSpecifiedCountStrategy<T> withMaxNumberOfRetries(@Nonnull NumberRequirement<Integer> requirement) {
        this._maxNumberOfRetries = IntegerGenerator.generateInteger(requirement);
        return this;
    }

    @Nonnull
    public RetryForSpecifiedCountStrategy<T> withMaxNumberOfRetries(@Nonnull @Including Integer from, @Nonnull @Excluding Integer to) {
        this._maxNumberOfRetries = IntegerGenerator.generateInteger(new IntegerRangeRequirement(from, to));
        return this;
    }

    @Nonnull
    public RetryForSpecifiedCountStrategy<T> withMaxNumberOfRetries(@Nonnegative int maxNumberOfRetries) {
        this._maxNumberOfRetries = maxNumberOfRetries;
        return this;
    }

    @Override
    public boolean isRetryRequiredForException(@Nonnull Throwable e, @Nonnull RetryingStatus status) {
        return this.isExceptionThatForceRetry(e) && status.getCurrentTry() < (long)this._maxNumberOfRetries;
    }

    @Override
    public void beforeTry(@Nonnull RetryingStatus status) {
        if (status.getCurrentTry() > 1L) {
            try {
                DurationGenerator.generateDuration(this.getWaitBetweenEachTry()).sleep();
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Nonnegative
    public int getMaxNumberOfRetries() {
        return this._maxNumberOfRetries;
    }
}

