/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.i18n;

import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;

public class CombinedResourceBundle
extends ResourceBundle {
    private final List<ResourceBundle> _resourceBundles;

    public CombinedResourceBundle(@Nonnull List<ResourceBundle> resourceBundles) {
        this._resourceBundles = Collections.unmodifiableList(resourceBundles);
    }

    @Override
    protected Object handleGetObject(String key) {
        Object result = null;
        Iterator<ResourceBundle> i = this._resourceBundles.iterator();
        while (result == null && i.hasNext()) {
            ResourceBundle resourceBundle = i.next();
            if (!resourceBundle.containsKey(key)) continue;
            result = resourceBundle.getObject(key);
        }
        return result;
    }

    @Override
    public Enumeration<String> getKeys() {
        HashSet<String> keys = new HashSet<String>();
        for (ResourceBundle resourceBundle : this._resourceBundles) {
            keys.addAll(resourceBundle.keySet());
        }
        return Iterators.asEnumeration(keys.iterator());
    }

    @Override
    public Locale getLocale() {
        return !this._resourceBundles.isEmpty() ? this._resourceBundles.iterator().next().getLocale() : null;
    }

    @Nonnull
    public List<ResourceBundle> getResourceBundles() {
        return this._resourceBundles;
    }
}

