/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.i18n;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.echocat.jomon.runtime.i18n.CombinedResourceBundle;
import org.echocat.jomon.runtime.iterators.ConvertingIterator;
import org.echocat.jomon.runtime.util.Entry;

@NotThreadSafe
public class ResourceBundles
implements Iterable<Entry<Locale, ResourceBundle>> {
    private static final Comparator<Locale> COMPARATOR = new Comparator<Locale>(){

        @Override
        public int compare(Locale o1, Locale o2) {
            return ResourceBundles.asString(o1).compareTo(ResourceBundles.asString(o2));
        }
    };
    private final Map<Locale, ResourceBundle> _localeToBundle = new TreeMap<Locale, ResourceBundle>(COMPARATOR);
    private final Map<Locale, ResourceBundle> _localeToBundleCache = new ConcurrentHashMap<Locale, ResourceBundle>();

    public void putBundle(@Nullable Locale locale, @Nonnull ResourceBundle resourceBundle) {
        this._localeToBundle.put(locale, resourceBundle);
    }

    @Nonnull
    public ResourceBundle getBundle(@Nullable Locale locale) throws NoSuchElementException {
        ResourceBundle resourceBundle = this._localeToBundleCache.get(locale);
        if (resourceBundle == null) {
            ResourceBundle bundle;
            ArrayList<ResourceBundle> candidates = new ArrayList<ResourceBundle>(10);
            if (!(locale == null || StringUtils.isEmpty((CharSequence)locale.getLanguage()) || StringUtils.isEmpty((CharSequence)locale.getCountry()) || StringUtils.isEmpty((CharSequence)locale.getVariant()) || (bundle = this._localeToBundle.get(new Locale(locale.getLanguage(), locale.getCountry(), locale.getVariant()))) == null)) {
                candidates.add(bundle);
            }
            if (locale != null && !StringUtils.isEmpty((CharSequence)locale.getLanguage()) && !StringUtils.isEmpty((CharSequence)locale.getCountry()) && (bundle = this._localeToBundle.get(new Locale(locale.getLanguage(), locale.getCountry()))) != null) {
                candidates.add(bundle);
            }
            if (locale != null && !StringUtils.isEmpty((CharSequence)locale.getLanguage()) && (bundle = this._localeToBundle.get(new Locale(locale.getLanguage()))) != null) {
                candidates.add(bundle);
            }
            if ((bundle = this._localeToBundle.get(new Locale(""))) != null) {
                candidates.add(bundle);
            }
            if (candidates.isEmpty()) {
                throw new NoSuchElementException("There is no bundle for locale " + locale + ".");
            }
            resourceBundle = new CombinedResourceBundle(candidates);
            this._localeToBundleCache.put(locale, resourceBundle);
        }
        return resourceBundle;
    }

    protected boolean containsBundle(@Nullable Locale locale) {
        return this._localeToBundle.containsKey(locale);
    }

    @Nonnull
    public String get(@Nullable Locale locale, @Nonnull String key) {
        ResourceBundle bundle = this.getBundle(locale);
        return bundle.getString(key);
    }

    @Nonnull
    public String get(@Nullable Locale locale, @Nonnull String key, Object ... parameters) {
        ResourceBundle bundle = this.getBundle(locale);
        return MessageFormat.format(bundle.getString(key), parameters);
    }

    @Override
    public Iterator<Entry<Locale, ResourceBundle>> iterator() {
        return new ConvertingIterator<Map.Entry<Locale, ResourceBundle>, Entry<Locale, ResourceBundle>>(this._localeToBundle.entrySet().iterator()){

            @Override
            protected Entry<Locale, ResourceBundle> convert(Map.Entry<Locale, ResourceBundle> input) {
                return new Entry.Impl<Locale, ResourceBundle>(input.getKey(), input.getValue());
            }
        };
    }

    @Nonnull
    private static String asString(@Nullable Locale locale) {
        return locale != null ? locale.toString() : "";
    }
}

