/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.i18n;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.runtime.i18n.RecursiveResourceBundleFactory;
import org.echocat.jomon.runtime.i18n.ResourceBundles;
import org.echocat.jomon.runtime.system.DynamicClassLoader;

@ThreadSafe
public class ResourceBundlesFactory {
    private final Map<Class<?>, ResourceBundles> _typeToBundleCache = new WeakHashMap();
    private final RecursiveResourceBundleFactory _recursiveResourceBundleFactory;
    private Set<Locale> _locales = Sets.newHashSet((Object[])new Locale[]{new Locale("")});

    public ResourceBundlesFactory(@Nonnull RecursiveResourceBundleFactory recursiveResourceBundleFactory) {
        this._recursiveResourceBundleFactory = recursiveResourceBundleFactory;
    }

    public void flushEntriesOf(@Nonnull ClassLoader classLoader) {
        this._recursiveResourceBundleFactory.flushEntriesOf(classLoader);
    }

    public void flushAllEntries() {
        this._recursiveResourceBundleFactory.flushAllEntries();
    }

    @Nonnull
    public ResourceBundles getFor(@Nonnull Class<?> type) {
        return this.getFor(type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ResourceBundles getFor(@Nonnull Class<?> type, @Nullable ClassLoader classLoader) {
        ResourceBundles resourceBundles;
        ClassLoader targetClassLoader;
        ClassLoader classLoader2 = targetClassLoader = classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
        if (targetClassLoader instanceof DynamicClassLoader && ((DynamicClassLoader)((Object)targetClassLoader)).isDynamic()) {
            resourceBundles = this.loadResourceBundles(type, targetClassLoader);
        } else {
            ResourceBundlesFactory resourceBundlesFactory = this;
            synchronized (resourceBundlesFactory) {
                resourceBundles = this._typeToBundleCache.get(type);
                if (resourceBundles == null) {
                    resourceBundles = this.loadResourceBundles(type, targetClassLoader);
                    this._typeToBundleCache.put(type, resourceBundles);
                }
            }
        }
        return resourceBundles;
    }

    @Nonnull
    protected ResourceBundles loadResourceBundles(@Nonnull Class<?> type, @Nonnull ClassLoader classLoader) {
        ResourceBundles resourceBundles = new ResourceBundles();
        for (Locale locale : this._locales) {
            ResourceBundle resourceBundle = this._recursiveResourceBundleFactory.getFor(type, classLoader, locale);
            resourceBundles.putBundle(locale, resourceBundle);
        }
        return resourceBundles;
    }

    @Nonnull
    public Set<Locale> getLocales() {
        return this._locales;
    }

    public void setLocalesFromCommaSeparatedString(String localesAsCommaSeparatedString) {
        if (localesAsCommaSeparatedString != null) {
            HashSet<Locale> locales = new HashSet<Locale>();
            for (String localeAsString : localesAsCommaSeparatedString.split(",")) {
                String trimmedLocalAsString = localeAsString.trim();
                if (trimmedLocalAsString.isEmpty()) continue;
                locales.add(Locale.forLanguageTag(trimmedLocalAsString));
            }
        } else {
            this.setLocales(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocales(Set<Locale> locales) {
        ResourceBundlesFactory resourceBundlesFactory = this;
        synchronized (resourceBundlesFactory) {
            this._locales = locales;
            this._typeToBundleCache.clear();
        }
    }
}

