/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.jaxb;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class SimpleXmlAdapter
extends XmlAdapter<String, Object> {
    private static final Map<String, XmlAdapter<String, ?>> PREFIX_TO_ADAPTER = SimpleXmlAdapter.createPrefixedAdaptersFor(Boolean.class, Byte.class, Short.class, Character.class, Integer.class, BigInteger.class, Long.class, Float.class, Double.class, BigDecimal.class, String.class, Date.class);

    @Nonnull
    private static Map<String, XmlAdapter<String, ?>> createPrefixedAdaptersFor(Class<?> ... types) {
        HashMap<String, XmlAdapter> prefixToAdapter = new HashMap<String, XmlAdapter>();
        for (Class<?> type : types) {
            XmlAdapter adapter;
            if (Character.class.equals(type)) {
                adapter = new CharacterBasedXmlAdapter();
            } else if (Date.class.equals(type)) {
                adapter = new DateBasedXmlAdapter();
            } else {
                adapter = ValueOfBasedXmlAdapter.tryCreateFor(type);
                if (adapter == null) {
                    adapter = ConstructorBasedXmlAdapter.tryCreateFor(type);
                }
            }
            if (adapter == null) {
                throw new IllegalArgumentException("Could not create adapter for: " + type.getName());
            }
            prefixToAdapter.put(type.getSimpleName().toLowerCase(), adapter);
        }
        return Collections.unmodifiableMap(prefixToAdapter);
    }

    public Object unmarshal(String v) throws Exception {
        Object result;
        if (v != null) {
            int separator = v.indexOf(58);
            if (separator <= 0 && v.length() <= separator + 1) {
                throw new IllegalArgumentException("Could not parse: " + v);
            }
            String prefix = v.substring(0, separator);
            String value = v.substring(separator + 1);
            XmlAdapter<String, ?> adapter = PREFIX_TO_ADAPTER.get(prefix);
            if (adapter == null) {
                throw new IllegalArgumentException("Could not parse: " + v);
            }
            result = adapter.unmarshal((Object)value);
        } else {
            result = null;
        }
        return result;
    }

    public String marshal(Object v) throws Exception {
        String result;
        if (v != null) {
            Class<?> type = v.getClass();
            String prefix = type.getSimpleName().toLowerCase();
            XmlAdapter<String, ?> adapter = PREFIX_TO_ADAPTER.get(prefix);
            if (adapter == null) {
                throw new IllegalArgumentException("Could not marshal: " + v);
            }
            result = prefix + ":" + (String)adapter.marshal(v);
        } else {
            result = null;
        }
        return result;
    }

    private static class DateBasedXmlAdapter
    extends XmlAdapter<String, Date> {
        private DateBasedXmlAdapter() {
        }

        public Date unmarshal(String v) throws Exception {
            return v != null ? new Date(Long.valueOf(v)) : null;
        }

        public String marshal(Date v) throws Exception {
            return v != null ? Long.toString(v.getTime()) : null;
        }
    }

    private static class CharacterBasedXmlAdapter
    extends XmlAdapter<String, Character> {
        private CharacterBasedXmlAdapter() {
        }

        public Character unmarshal(String v) throws Exception {
            return v != null && !v.isEmpty() ? Character.valueOf(v.charAt(0)) : null;
        }

        public String marshal(Character v) throws Exception {
            return v != null ? new String(new char[]{v.charValue()}) : null;
        }
    }

    private static class ConstructorBasedXmlAdapter<T>
    extends XmlAdapter<String, T> {
        private final Constructor<T> _constructor;

        @Nullable
        private static <T> ConstructorBasedXmlAdapter<T> tryCreateFor(@Nonnull Class<T> type) {
            Constructor<T> constructor = ConstructorBasedXmlAdapter.findConstructorFor(type);
            return constructor != null ? new ConstructorBasedXmlAdapter<T>(constructor) : null;
        }

        @Nullable
        private static <T> Constructor<T> findConstructorFor(@Nonnull Class<T> type) {
            Constructor<T> result;
            try {
                result = type.getConstructor(String.class);
            }
            catch (NoSuchMethodException ignored) {
                result = null;
            }
            return result;
        }

        private ConstructorBasedXmlAdapter(@Nonnull Constructor<T> constructor) {
            this._constructor = constructor;
        }

        public T unmarshal(String v) throws Exception {
            return v != null ? (T)this._constructor.newInstance(v) : null;
        }

        public String marshal(T v) throws Exception {
            return v != null ? v.toString() : null;
        }
    }

    private static class ValueOfBasedXmlAdapter<T>
    extends XmlAdapter<String, T> {
        private final Method _valueOfMethod;

        @Nullable
        private static <T> ValueOfBasedXmlAdapter<T> tryCreateFor(@Nonnull Class<T> type) {
            Method method = ValueOfBasedXmlAdapter.findValueOfMethodFor(type);
            return method != null ? new ValueOfBasedXmlAdapter<T>(method) : null;
        }

        @Nullable
        private static Method findValueOfMethodFor(@Nonnull Class<?> type) {
            Method result;
            try {
                result = type.getMethod("valueOf", String.class);
                int modifiers = result.getModifiers();
                if (!result.getReturnType().equals(type) || !Modifier.isStatic(modifiers)) {
                    result = null;
                }
            }
            catch (NoSuchMethodException ignored) {
                result = null;
            }
            return result;
        }

        private ValueOfBasedXmlAdapter(@Nonnull Method valueOfMethod) {
            this._valueOfMethod = valueOfMethod;
        }

        public T unmarshal(String v) throws Exception {
            return (T)(v != null ? this._valueOfMethod.invoke(null, v) : null);
        }

        public String marshal(T v) throws Exception {
            return v != null ? v.toString() : null;
        }
    }
}

