/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.numbers;

import javax.annotation.Nonnull;
import org.apache.commons.math3.random.RandomData;
import org.apache.commons.math3.random.RandomDataImpl;
import org.echocat.jomon.runtime.generation.Generator;
import org.echocat.jomon.runtime.numbers.DoubleRange;
import org.echocat.jomon.runtime.numbers.DoubleRangeRequirement;
import org.echocat.jomon.runtime.numbers.ExactDoubleRequirement;
import org.echocat.jomon.runtime.numbers.NumberRequirement;

public class DoubleGenerator
implements Generator<Double, NumberRequirement<Double>> {
    private static final RandomData RANDOM = new RandomDataImpl();
    private static final DoubleGenerator INSTANCE = new DoubleGenerator();

    @Nonnull
    public static Double generateDouble(@Nonnull NumberRequirement<Double> requirement) {
        return INSTANCE.generate(requirement);
    }

    @Override
    @Nonnull
    public Double generate(@Nonnull NumberRequirement<Double> requirement) {
        Double value;
        if (requirement instanceof ExactDoubleRequirement) {
            value = this.generateExact((ExactDoubleRequirement)requirement);
        } else if (requirement instanceof DoubleRangeRequirement) {
            value = this.generateInRange((DoubleRangeRequirement)requirement);
        } else {
            throw new IllegalArgumentException("Don't know how to handle requirement: " + requirement);
        }
        return value;
    }

    @Nonnull
    protected Double generateExact(@Nonnull ExactDoubleRequirement requirement) {
        Double value = (Double)requirement.getValue();
        return value != null ? value : 0.0;
    }

    @Nonnull
    protected Double generateInRange(@Nonnull DoubleRangeRequirement requirement) {
        DoubleRange range = (DoubleRange)requirement.getValue();
        Double from = (Double)range.getFrom();
        Double to = (Double)range.getTo();
        return RANDOM.nextUniform(from != null ? from : Double.MIN_VALUE, to != null ? to : Double.MAX_VALUE);
    }
}

