/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.numbers;

import javax.annotation.Nonnull;
import org.apache.commons.math3.random.RandomData;
import org.apache.commons.math3.random.RandomDataImpl;
import org.echocat.jomon.runtime.generation.Generator;
import org.echocat.jomon.runtime.numbers.ExactIntegerRequirement;
import org.echocat.jomon.runtime.numbers.IntegerRange;
import org.echocat.jomon.runtime.numbers.IntegerRangeRequirement;
import org.echocat.jomon.runtime.numbers.NumberRequirement;

public class IntegerGenerator
implements Generator<Integer, NumberRequirement<Integer>> {
    private static final RandomData RANDOM = new RandomDataImpl();
    private static final IntegerGenerator INSTANCE = new IntegerGenerator();

    @Nonnull
    public static Integer generateInteger(@Nonnull NumberRequirement<Integer> requirement) {
        return INSTANCE.generate(requirement);
    }

    @Override
    @Nonnull
    public Integer generate(@Nonnull NumberRequirement<Integer> requirement) {
        Integer integer;
        if (requirement instanceof ExactIntegerRequirement) {
            integer = this.generateExact((ExactIntegerRequirement)requirement);
        } else if (requirement instanceof IntegerRangeRequirement) {
            integer = this.generateInRange((IntegerRangeRequirement)requirement);
        } else {
            throw new IllegalArgumentException("Don't know how to handle requirement: " + requirement);
        }
        return integer;
    }

    @Nonnull
    protected Integer generateExact(@Nonnull ExactIntegerRequirement requirement) {
        return (Integer)requirement.getValue();
    }

    @Nonnull
    protected Integer generateInRange(@Nonnull IntegerRangeRequirement requirement) {
        IntegerRange range = (IntegerRange)requirement.getValue();
        return RANDOM.nextSecureInt(((Integer)range.getFrom()).intValue(), ((Integer)range.getTo()).intValue());
    }
}

