/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.numbers;

import javax.annotation.Nonnull;
import org.apache.commons.math3.random.RandomData;
import org.apache.commons.math3.random.RandomDataImpl;
import org.echocat.jomon.runtime.generation.Generator;
import org.echocat.jomon.runtime.numbers.ExactLongRequirement;
import org.echocat.jomon.runtime.numbers.LongRange;
import org.echocat.jomon.runtime.numbers.LongRangeRequirement;
import org.echocat.jomon.runtime.numbers.NumberRequirement;

public class LongGenerator
implements Generator<Long, NumberRequirement<Long>> {
    private static final RandomData RANDOM = new RandomDataImpl();
    private static final LongGenerator INSTANCE = new LongGenerator();

    @Nonnull
    public static Long generateLong(@Nonnull NumberRequirement<Long> requirement) {
        return INSTANCE.generate(requirement);
    }

    @Override
    @Nonnull
    public Long generate(@Nonnull NumberRequirement<Long> requirement) {
        Long Long2;
        if (requirement instanceof ExactLongRequirement) {
            Long2 = this.generateExact((ExactLongRequirement)requirement);
        } else if (requirement instanceof LongRangeRequirement) {
            Long2 = this.generateInRange((LongRangeRequirement)requirement);
        } else {
            throw new IllegalArgumentException("Don't know how to handle requirement: " + requirement);
        }
        return Long2;
    }

    @Nonnull
    protected Long generateExact(@Nonnull ExactLongRequirement requirement) {
        Long value = (Long)requirement.getValue();
        return value != null ? value : 0L;
    }

    @Nonnull
    protected Long generateInRange(@Nonnull LongRangeRequirement requirement) {
        LongRange range = (LongRange)requirement.getValue();
        Long from = (Long)range.getFrom();
        Long to = (Long)range.getTo();
        return RANDOM.nextSecureLong(from != null ? from : Long.MIN_VALUE, to != null ? to : Long.MAX_VALUE);
    }
}

