/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.reflection;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ClassUtils {
    @Nullable
    public static Class<?> toClass(@Nullable Type type) {
        Class<?> result;
        if (type == null) {
            result = null;
        } else if (type instanceof Class) {
            result = (Class<?>)type;
        } else if (type instanceof ParameterizedType) {
            result = ClassUtils.toClass(((ParameterizedType)type).getRawType());
        } else if (type instanceof TypeVariable) {
            result = ClassUtils.toClass(((TypeVariable)type).getBounds()[0]);
        } else {
            throw new IllegalArgumentException("Could not handle: " + type);
        }
        return result;
    }

    @Nullable
    public static Type tryExtractComponentTypeOfIterable(@Nonnull Type type) {
        Class<Object> result;
        if (type instanceof Class) {
            Class aClass = (Class)type;
            result = !(Iterable.class.isAssignableFrom(aClass) || Iterator.class.isAssignableFrom(aClass) || aClass.isArray()) ? null : (aClass.isArray() ? aClass.getComponentType() : Object.class);
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class<?> aClass = ClassUtils.toClass(parameterizedType.getRawType());
            result = !(Iterable.class.isAssignableFrom(aClass) || Iterator.class.isAssignableFrom(aClass) || aClass.isArray()) ? null : parameterizedType.getActualTypeArguments()[0];
        } else if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            Class<?> aClass = ClassUtils.toClass(typeVariable.getBounds()[0]);
            result = !(Iterable.class.isAssignableFrom(aClass) || Iterator.class.isAssignableFrom(aClass) || aClass.isArray()) ? null : typeVariable.getBounds()[0];
        } else {
            throw new IllegalArgumentException("Could not handle: " + type);
        }
        return result;
    }

    @Nullable
    public static Class<?> tryExtractComponentClassOfIterable(@Nonnull Type type) {
        Type componentType = ClassUtils.tryExtractComponentTypeOfIterable(type);
        return componentType != null ? ClassUtils.toClass(componentType) : null;
    }

    @Nonnull
    public static Type extractComponentTypeOfIterable(@Nonnull Type type) {
        Type result = ClassUtils.tryExtractComponentTypeOfIterable(type);
        if (result == null) {
            throw new IllegalArgumentException(type + " is neither of type " + Iterable.class.getName() + " nor an array.");
        }
        return result;
    }

    @Nonnull
    public static Class<?> extractComponentClassOfIterable(@Nonnull Type type) {
        Type componentType = ClassUtils.extractComponentTypeOfIterable(type);
        return ClassUtils.toClass(componentType);
    }

    @Nonnull
    public static Type tryExtractComponentTypeOfIterable(@Nonnull PropertyDescriptor descriptor) {
        Type result = null;
        Method readMethod = descriptor.getReadMethod();
        if (readMethod != null) {
            result = ClassUtils.tryExtractComponentTypeOfIterable(readMethod.getGenericReturnType());
        }
        if (result == null) {
            Method writeMethod = descriptor.getWriteMethod();
            if (writeMethod != null) {
                Type[] genericParameterTypes = readMethod.getGenericParameterTypes();
                result = genericParameterTypes.length == 1 ? ClassUtils.tryExtractComponentTypeOfIterable(genericParameterTypes[0]) : null;
            } else if (readMethod == null) {
                throw new IllegalArgumentException("The descriptor " + descriptor + " has neither a setter nor a getter?");
            }
        }
        return result;
    }

    @Nonnull
    public static Class<?> tryExtractComponentClassOfIterable(@Nonnull PropertyDescriptor descriptor) {
        Type componentType = ClassUtils.tryExtractComponentTypeOfIterable(descriptor);
        return componentType != null ? ClassUtils.toClass(componentType) : null;
    }

    @Nonnull
    public static Type extractComponentTypeOfIterable(@Nonnull PropertyDescriptor descriptor) {
        Type result = ClassUtils.tryExtractComponentTypeOfIterable(descriptor);
        if (result == null) {
            throw new IllegalArgumentException("Type of " + descriptor + " is neither of type " + Iterable.class.getName() + " nor an array.");
        }
        return result;
    }

    @Nonnull
    public static Class<?> extractComponentClassOfIterable(@Nonnull PropertyDescriptor descriptor) {
        Type result = ClassUtils.extractComponentTypeOfIterable(descriptor);
        return ClassUtils.toClass(result);
    }

    @Nonnull
    public static Type getGenericTypeOf(@Nonnull PropertyDescriptor descriptor) {
        Type result = null;
        Method readMethod = descriptor.getReadMethod();
        if (readMethod != null) {
            result = readMethod.getGenericReturnType();
        } else {
            Method writeMethod = descriptor.getWriteMethod();
            if (writeMethod != null) {
                result = readMethod.getGenericParameterTypes()[0];
            } else if (readMethod == null) {
                throw new IllegalArgumentException("The descriptor " + descriptor + " has neither a setter nor a getter?");
            }
        }
        return result;
    }

    @Nonnull
    public static Method getPublicMethodOf(@Nonnull Class<?> ofType, @Nonnull Class<?> returnType, @Nonnull String methodName, Class<?> ... parameterTypes) {
        try {
            Method method = ofType.getMethod(methodName, parameterTypes);
            int modifiers = method.getModifiers();
            if (Modifier.isStatic(modifiers)) {
                throw new IllegalArgumentException(method + " is static.");
            }
            if (!Modifier.isPublic(modifiers)) {
                throw new IllegalArgumentException(method + " is not public.");
            }
            if (!returnType.equals(method.getReturnType())) {
                throw new IllegalArgumentException(method + " does not return " + returnType.getName() + ".");
            }
            return method;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Could not find public static " + returnType.getSimpleName() + " " + ofType.getSimpleName() + "." + methodName + "(" + Arrays.toString(parameterTypes) + ").", e);
        }
    }

    @Nullable
    public static <T extends Annotation> T findAnnotation(@Nonnull Class<T> annotationType, @Nonnull PropertyDescriptor of) {
        Object result;
        Method readMethod = of.getReadMethod();
        Object v0 = result = readMethod != null ? readMethod.getAnnotation(annotationType) : null;
        if (result == null) {
            Method writeMethod = of.getWriteMethod();
            result = writeMethod != null ? writeMethod.getAnnotation(annotationType) : null;
        }
        return result;
    }

    private ClassUtils() {
    }
}

