/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.repository;

import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.echocat.jomon.runtime.concurrent.RetryForSpecifiedCountStrategy;
import org.echocat.jomon.runtime.concurrent.Retryer;
import org.echocat.jomon.runtime.concurrent.RetryingStrategy;
import org.echocat.jomon.runtime.repository.QueryableRepository;
import org.echocat.jomon.runtime.repository.SafeUpdatingRepository;

public class SafeUpdater {
    private static final SafeUpdater DEFAULT = SafeUpdater.safeUpdater();
    protected static final RetryingStrategy<Void> DEFAULT_STRATEGY = ((RetryForSpecifiedCountStrategy)RetryForSpecifiedCountStrategy.retryForSpecifiedCountOf(10).withExceptionsThatForceRetry(ConcurrentModificationException.class)).asUnmodifiable();
    private RetryingStrategy<Void> _strategy = DEFAULT_STRATEGY;

    @Nonnull
    public static SafeUpdater safe() {
        return SafeUpdater.getInstance();
    }

    @Nonnull
    public static SafeUpdater getInstance() {
        return DEFAULT;
    }

    @Nonnull
    public static SafeUpdater safeUpdater() {
        return new SafeUpdater();
    }

    public <V, ID, E extends ConcurrentModificationException, R extends SafeUpdatingRepository<V, E> & QueryableRepository<?, ID, V>> void update(final @Nonnull ID id, final @Nonnull R on, final @Nonnull Modifier<V> using) throws E, NoSuchElementException {
        Retryer.executeWithRetry(new Runnable(){

            @Override
            public void run() {
                Object value = ((QueryableRepository)((Object)on)).findOneBy(id);
                if (value == null) {
                    throw new NoSuchElementException("Could not find object #" + id);
                }
                using.modifyBeforeUpdate(value);
                on.updateSafe(value);
            }
        }, this._strategy != null ? this._strategy : DEFAULT_STRATEGY);
    }

    public SafeUpdater withRetryingStrategy(@Nonnull RetryingStrategy<Void> strategy) {
        this.setStrategy(strategy);
        return this;
    }

    @Nonnull
    public RetryingStrategy<Void> getStrategy() {
        return this._strategy;
    }

    public void setStrategy(@Nonnull RetryingStrategy<Void> strategy) {
        this.defaultCheck();
        if (strategy == null) {
            throw new NullPointerException();
        }
        this._strategy = strategy;
    }

    protected void defaultCheck() {
        if (DEFAULT == this) {
            throw new IllegalStateException("You are not allowed to modify the default instance of " + this.getClass().getName() + ".");
        }
    }

    public static interface Modifier<V> {
        public void modifyBeforeUpdate(@Nonnull V var1);
    }
}

