/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.runtime.iterators.ConvertingIterator;
import org.echocat.jomon.runtime.util.Entry;
import org.echocat.jomon.runtime.util.Hint;

@NotThreadSafe
public class Hints
implements Iterable<Entry<Hint<?>, Object>> {
    public static final Hints EMPTY_HINTS = Hints.unmodifiableHints(new Hints());
    private final Map<Hint<?>, Object> _hintToValue = new HashMap();

    @Nonnull
    public static Hints unmodifiableHints(@Nullable Hints hints) {
        return new Hints(hints){

            @Override
            public <T> void set(@Nonnull Hint<T> hint, @Nullable T value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public <T> void remove(@Nonnull Hint<T> hint) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Iterator<Entry<Hint<?>, Object>> iterator() {
                final Iterator<Entry<Hint<?>, Object>> i = super.iterator();
                return new Iterator<Entry<Hint<?>, Object>>(){

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public Entry<Hint<?>, Object> next() {
                        return (Entry)i.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static Hints hints(Object ... parameters) {
        Map<Hint<?>, Object> plainHints = CollectionUtils.asMap(parameters);
        return new Hints(parameters != null ? plainHints : null);
    }

    @Nonnull
    public static Hints nonNullHints(@Nullable Hints hints) {
        return hints != null ? hints : EMPTY_HINTS;
    }

    public Hints() {
    }

    public Hints(@Nullable Hints hints) {
        if (hints != null) {
            this._hintToValue.putAll(hints.getHintToValue());
        }
    }

    public Hints(@Nullable Map<Hint<?>, Object> hints) {
        if (hints != null) {
            this._hintToValue.putAll(hints);
        }
    }

    public <T> void set(@Nonnull Hint<T> hint, @Nullable T value) {
        Class<T> valueType = hint.getValueType();
        if (value != null && !valueType.isInstance(value)) {
            throw new IllegalArgumentException("The given value is not of type " + hint.getValueType().getName() + " which is expected by " + hint + ".");
        }
        if (!hint.isNullValueAllowed() && value == null) {
            throw new NullPointerException(hint + " does not accept null values.");
        }
        this.getHintToValue().put(hint, value);
    }

    @Nullable
    public <T> T get(@Nonnull Hint<T> hint) {
        return this.get(hint, hint.getDefaultValue());
    }

    @Nullable
    public static <T> T get(@Nullable Hints hints, @Nonnull Hint<T> hint) {
        return hints != null ? (T)hints.get(hint) : null;
    }

    @Nullable
    public <T> T get(@Nonnull Hint<T> hint, @Nullable T defaultValue) {
        Object plainValue;
        Class<T> valueType = hint.getValueType();
        T value = valueType.cast(plainValue = this.getHintToValue().get(hint));
        return value != null ? value : defaultValue;
    }

    @Nullable
    public static <T> T get(@Nullable Hints hints, @Nonnull Hint<T> hint, @Nullable T defaultValue) {
        return hints != null ? (T)hints.get(hint, defaultValue) : null;
    }

    public boolean isEnabled(@Nonnull Hint<Boolean> hint) {
        return this.isEnabled(hint, hint.getDefaultValue());
    }

    public static boolean isEnabled(@Nullable Hints hints, @Nonnull Hint<Boolean> hint) {
        return Hints.isEnabled(hints, hint, hint.getDefaultValue());
    }

    public boolean isEnabled(@Nonnull Hint<Boolean> hint, boolean defaultValue) {
        Boolean value = this.get(hint, defaultValue);
        return Boolean.TRUE.equals(value);
    }

    public static boolean isEnabled(@Nullable Hints hints, @Nonnull Hint<Boolean> hint, boolean defaultValue) {
        return hints != null ? hints.isEnabled(hint, defaultValue) : defaultValue;
    }

    public <T> void remove(@Nonnull Hint<T> hint) {
        this.getHintToValue().remove(hint);
    }

    public boolean isSet(@Nonnull Hint<?> hint) {
        return this.getHintToValue().get(hint) != null || hint.getDefaultValue() != null;
    }

    public static boolean isSet(@Nullable Hints hints, @Nonnull Hint<?> hint) {
        return hints != null && hints.isSet(hint);
    }

    public <T> boolean is(@Nonnull Hint<T> hint, @Nullable T expected, @Nullable T defaultValue) {
        T value = this.get(hint, defaultValue);
        return expected != null ? expected.equals(value) : value == null;
    }

    public static <T> boolean is(@Nullable Hints hints, @Nonnull Hint<T> hint, @Nullable T expected, @Nullable T defaultValue) {
        return hints != null && hints.is(hint, expected, defaultValue);
    }

    public <T> boolean is(@Nonnull Hint<T> hint, @Nullable T expected) {
        return this.is(hint, expected, hint.getDefaultValue());
    }

    public static <T> boolean is(@Nullable Hints hints, @Nonnull Hint<T> hint, @Nullable T expected) {
        return hints != null && hints.is(hint, expected);
    }

    @Override
    public Iterator<Entry<Hint<?>, Object>> iterator() {
        return new ConvertingIterator<Map.Entry<Hint<?>, Object>, Entry<Hint<?>, Object>>(this.getHintToValue().entrySet().iterator()){

            @Override
            protected Entry<Hint<?>, Object> convert(Map.Entry<Hint<?>, Object> input) {
                return new Entry.Impl(input.getKey(), input.getValue());
            }
        };
    }

    @Nonnull
    protected Map<Hint<?>, Object> getHintToValue() {
        return this._hintToValue;
    }

    public boolean equals(Object o) {
        boolean result = this == o ? true : (!(o instanceof Hints) ? false : this.getHintToValue().equals(((Hints)o).getHintToValue()));
        return result;
    }

    public int hashCode() {
        return this.getHintToValue().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean first = true;
        for (Entry<Hint<?>, Object> hintToValue : this) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(hintToValue.getKey()).append("=").append(hintToValue.getValue());
        }
        sb.append('}');
        return sb.toString();
    }
}

