/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.util;

import javax.annotation.Nullable;

public class ResourceUtils {
    public static void closeQuietly(@Nullable AutoCloseable autoCloseable) {
        try {
            if (autoCloseable != null) {
                autoCloseable.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static <T extends AutoCloseable> void closeQuietly(@Nullable Iterable<? extends T> elements) {
        try {
            if (elements != null) {
                for (T element : elements) {
                    if (!(element instanceof AutoCloseable)) continue;
                    ResourceUtils.closeQuietly((AutoCloseable)element);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static <T extends AutoCloseable> void closeQuietly(@Nullable T[] elements) {
        try {
            if (elements != null) {
                for (T element : elements) {
                    if (!(element instanceof AutoCloseable)) continue;
                    ResourceUtils.closeQuietly((AutoCloseable)element);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ResourceUtils() {
    }
}

