/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jemoni.jmx;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import org.echocat.jemoni.jmx.ArgumentDefinition;
import org.echocat.jemoni.jmx.AttributeDefinition;
import org.echocat.jemoni.jmx.BeanDefinition;
import org.echocat.jemoni.jmx.OperationDefinition;
import org.echocat.jemoni.jmx.reflection.ReflectionBasedUtils;

public class BeanFacade<B>
implements DynamicMBean {
    private final B _bean;
    private final BeanDefinition<B> _beanDefinition;
    private final Map<String, OperationDefinition<B>> _nameToOperation;
    private final Map<String, AttributeDefinition<?, B>> _nameToAttribute;

    public BeanFacade(@Nonnull B bean, @Nullable BeanDefinition<B> beanDefinition) {
        this._bean = bean;
        this._beanDefinition = beanDefinition;
        this._nameToOperation = this.asNameToOperation(beanDefinition.getOperationDefinitions());
        this._nameToAttribute = this.asNameToAttribute(beanDefinition.getAttributeDefinitions());
    }

    @Override
    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        AttributeDefinition<?, B> attributeDefinition = this._nameToAttribute.get(name);
        if (attributeDefinition == null) {
            throw new AttributeNotFoundException(name);
        }
        try {
            return attributeDefinition.get(this._bean);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof Exception) {
                throw new ReflectionException((Exception)target, target.getMessage());
            }
            throw new ReflectionException(e);
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        String name = attribute.getName();
        AttributeDefinition<?, B> attributeDefinition = this._nameToAttribute.get(name);
        if (attributeDefinition == null) {
            throw new AttributeNotFoundException(name);
        }
        Class<?> requiredType = attributeDefinition.getType();
        Object value = ReflectionBasedUtils.correctValueIfNeeded(requiredType, attribute.getValue());
        if (value != null && !requiredType.isInstance(value)) {
            throw new InvalidAttributeValueException();
        }
        try {
            attributeDefinition.set(this._bean, value);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof Exception) {
                throw new ReflectionException((Exception)target, target.getMessage());
            }
            throw new ReflectionException(e);
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object invoke(String name, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        OperationDefinition<B> operationDefinition = this._nameToOperation.get(name);
        if (operationDefinition == null) {
            throw new UnsupportedOperationException(name);
        }
        try {
            return operationDefinition.invoke(this._bean, params);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof Exception) {
                throw new ReflectionException((Exception)target, target.getMessage());
            }
            throw new ReflectionException(e);
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return new MBeanInfo(this._bean.getClass().getName(), this._beanDefinition.getDescription(), this.toMBeanAttributes(this._nameToAttribute.values()), new MBeanConstructorInfo[0], this.toMBeanOperations(this._nameToOperation.values()), new MBeanNotificationInfo[0]);
    }

    @Nonnull
    protected MBeanOperationInfo[] toMBeanOperations(@Nonnull Iterable<OperationDefinition<B>> operations) {
        ArrayList<MBeanOperationInfo> result = new ArrayList<MBeanOperationInfo>();
        for (OperationDefinition<B> operation : operations) {
            result.add(this.toMBeanOperation(operation));
        }
        return result.toArray(new MBeanOperationInfo[result.size()]);
    }

    @Nonnull
    protected MBeanOperationInfo toMBeanOperation(@Nonnull OperationDefinition<B> operation) {
        Class<?> returnType = operation.getReturnType();
        return new MBeanOperationInfo(operation.getName(), operation.getDescription(), this.getMBeanParameterInfoFor(operation), Void.class.equals(returnType) ? "void" : returnType.getName(), 1);
    }

    @Nonnull
    protected MBeanParameterInfo[] getMBeanParameterInfoFor(@Nonnull OperationDefinition<B> operation) {
        ArgumentDefinition[] argumentDefinitions = operation.getArgumentDefinitions();
        MBeanParameterInfo[] all = new MBeanParameterInfo[argumentDefinitions.length];
        for (int i = 0; i < argumentDefinitions.length; ++i) {
            ArgumentDefinition argumentDefinition = argumentDefinitions[i];
            all[i] = new MBeanParameterInfo(argumentDefinition.getName(), argumentDefinition.getType().getName(), argumentDefinition.getDescription());
        }
        return all;
    }

    @Nonnull
    protected MBeanAttributeInfo[] toMBeanAttributes(@Nonnull Iterable<AttributeDefinition<?, B>> attributes) {
        ArrayList<MBeanAttributeInfo> result = new ArrayList<MBeanAttributeInfo>();
        for (AttributeDefinition<?, B> attribute : attributes) {
            result.add(this.toMBeanAttribute(attribute));
        }
        return result.toArray(new MBeanAttributeInfo[result.size()]);
    }

    @Nonnull
    protected MBeanAttributeInfo toMBeanAttribute(@Nonnull AttributeDefinition<?, B> attribute) {
        AttributeDefinition.AccessMode accessMode = attribute.getAccessMode();
        Class<?> type = attribute.getType();
        return new MBeanAttributeInfo(attribute.getName(), type.getName(), attribute.getDescription(), accessMode.isReadingPossible(), accessMode.isWritingPossible(), Boolean.class.isAssignableFrom(type));
    }

    @Nonnull
    protected Map<String, OperationDefinition<B>> asNameToOperation(@Nullable Iterable<OperationDefinition<B>> operations) {
        TreeMap<String, OperationDefinition<B>> result = new TreeMap<String, OperationDefinition<B>>();
        if (operations != null) {
            for (OperationDefinition<B> operation : operations) {
                result.put(operation.getName(), operation);
            }
        }
        return result;
    }

    @Nonnull
    protected Map<String, AttributeDefinition<?, B>> asNameToAttribute(@Nullable Iterable<AttributeDefinition<?, B>> attributes) {
        TreeMap result = new TreeMap();
        if (attributes != null) {
            for (AttributeDefinition<?, B> attribute : attributes) {
                result.put(attribute.getName(), attribute);
            }
        }
        return result;
    }

    public String toString() {
        return "BeanFacade for " + this._bean;
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            result = true;
        } else if (!(o instanceof BeanFacade)) {
            result = false;
        } else {
            BeanFacade that = (BeanFacade)o;
            result = this._bean.equals(that._bean);
        }
        return result;
    }

    public int hashCode() {
        return this._bean.hashCode();
    }
}

