/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jemoni.jmx.reflection;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.echocat.jemoni.jmx.AttributeAccessor;
import org.echocat.jemoni.jmx.AttributeDefinition;
import org.echocat.jemoni.jmx.reflection.ReflectionBasedAttributeAccessor;

public class ReflectionBasedAttributeDefinition<T, B>
implements AttributeDefinition<T, B> {
    private final PropertyDescriptor _descriptor;
    private String _name;
    private String _description;
    private AttributeDefinition.AccessMode _accessMode;
    private AttributeAccessor<T, B> _accessor;

    @Nonnull
    public ReflectionBasedAttributeDefinition(@Nonnull PropertyDescriptor descriptor) {
        this._descriptor = descriptor;
        this.setName(null);
        this.setDescription(null);
        this.setAccessMode(null);
        this.setAccessor(null);
    }

    @Override
    @Nonnull
    public String getName() {
        return this._name;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this._description;
    }

    @Override
    @Nonnull
    public Class<T> getType() {
        return this._accessor.getType();
    }

    @Override
    @Nonnull
    public AttributeDefinition.AccessMode getAccessMode() {
        return this._accessMode;
    }

    @Override
    @Nullable
    public T get(@Nonnull B bean) throws Exception {
        Method readMethod = this._descriptor.getReadMethod();
        if (readMethod == null || !this.getAccessMode().isReadingPossible()) {
            throw new UnsupportedOperationException("Read is not supported from " + this + ".");
        }
        return this._accessor.get(bean);
    }

    @Override
    public void set(@Nonnull B bean, @Nullable T value) throws Exception {
        Method writeMethod = this._descriptor.getWriteMethod();
        if (writeMethod == null || !this.getAccessMode().isWritingPossible()) {
            throw new UnsupportedOperationException("Write is not supported on " + this + ".");
        }
        this._accessor.set(bean, value);
    }

    public void setName(@Nullable String name) {
        this._name = !StringUtils.isEmpty((CharSequence)name) ? name : this._descriptor.getName();
    }

    public void setDescription(@Nullable String description) {
        String shortDescription;
        this._description = !StringUtils.isEmpty((CharSequence)description) ? description : (!StringUtils.isEmpty((CharSequence)(shortDescription = this._descriptor.getShortDescription())) && !shortDescription.equals(this._descriptor.getDisplayName()) ? shortDescription : null);
    }

    public void setAccessMode(@Nullable AttributeDefinition.AccessMode accessMode) {
        this._accessMode = accessMode != null && accessMode != AttributeDefinition.AccessMode.undefined ? accessMode : this.getAccessModeBy(this._descriptor);
    }

    public void setAccessor(@Nullable AttributeAccessor<T, B> accessor) {
        this._accessor = accessor != null ? accessor : this.getAccessorFor(this._descriptor);
    }

    @Nonnull
    protected AttributeDefinition.AccessMode getAccessModeBy(@Nonnull PropertyDescriptor descriptor) {
        AttributeDefinition.AccessMode accessMode;
        Method readMethod = descriptor.getReadMethod();
        Method writeMethod = descriptor.getWriteMethod();
        if (readMethod != null && writeMethod != null) {
            accessMode = AttributeDefinition.AccessMode.readWrite;
        } else if (readMethod != null) {
            accessMode = AttributeDefinition.AccessMode.readOnly;
        } else if (writeMethod != null) {
            accessMode = AttributeDefinition.AccessMode.writeOnly;
        } else {
            throw new IllegalStateException("There is no read and no write method?");
        }
        return accessMode;
    }

    @Nonnull
    protected AttributeAccessor<T, B> getAccessorFor(@Nonnull PropertyDescriptor descriptor) {
        return new ReflectionBasedAttributeAccessor(descriptor);
    }

    @Nonnull
    protected PropertyDescriptor getDescriptor() {
        return this._descriptor;
    }

    @Nonnull
    protected AttributeAccessor<T, B> getAccessor() {
        return this._accessor;
    }

    public String toString() {
        AttributeDefinition.AccessMode accessMode = this.getAccessMode();
        String am = accessMode == AttributeDefinition.AccessMode.readOnly ? " (r)" : (accessMode == AttributeDefinition.AccessMode.writeOnly ? " (w)" : (accessMode == AttributeDefinition.AccessMode.readWrite ? " (rw)" : ""));
        return this.getType().getName() + " " + this.getName() + am;
    }
}

