/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jemoni.jmx.reflection;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jemoni.jmx.AttributeAccessor;
import org.echocat.jemoni.jmx.AttributeDefinition;
import org.echocat.jemoni.jmx.AttributeDefinitionDiscovery;
import org.echocat.jemoni.jmx.annotations.Attribute;
import org.echocat.jemoni.jmx.reflection.ReflectionBasedAttributeDefinition;

public class ReflectionBasedAttributeDefinitionDiscovery
implements AttributeDefinitionDiscovery {
    private static final ReflectionBasedAttributeDefinitionDiscovery INSTANCE = new ReflectionBasedAttributeDefinitionDiscovery();
    private final Map<Class<?>, Set<AttributeDefinition<?, ?>>> _typeToDefinitionsCache = new WeakHashMap();

    @Nonnull
    public static ReflectionBasedAttributeDefinitionDiscovery reflectionBasedAttributeDefinitionDiscovery() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public <B> Set<AttributeDefinition<?, B>> discoverFor(@Nonnull Class<B> beanType) {
        Set<AttributeDefinition<?, Object>> result;
        Map<Class<?>, Set<AttributeDefinition<?, ?>>> map = this._typeToDefinitionsCache;
        synchronized (map) {
            result = this._typeToDefinitionsCache.get(beanType);
        }
        if (result == null) {
            result = this.generateDefinitionsFor(beanType);
            map = this._typeToDefinitionsCache;
            synchronized (map) {
                this._typeToDefinitionsCache.put(beanType, result);
            }
        }
        return result;
    }

    @Nonnull
    protected Set<AttributeDefinition<?, ?>> generateDefinitionsFor(@Nonnull Class<?> beanType) {
        HashSet result = new HashSet();
        BeanInfo beanInfo = this.getBeanInfoFor(beanType);
        for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
            Attribute attribute = this.findAnnotationFor(descriptor);
            if (attribute == null) continue;
            result.add(this.generateDefinitionFor(descriptor, attribute));
        }
        return Collections.unmodifiableSet(result);
    }

    @Nonnull
    protected BeanInfo getBeanInfoFor(@Nonnull Class<?> beanType) {
        try {
            return beanType.isInterface() ? Introspector.getBeanInfo(beanType) : Introspector.getBeanInfo(beanType, Object.class);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Could not retrieve bean info for " + beanType.getName() + ".", e);
        }
    }

    @Nullable
    protected Attribute findAnnotationFor(@Nonnull PropertyDescriptor descriptor) {
        Attribute attribute;
        Method readMethod = descriptor.getReadMethod();
        Method writeMethod = descriptor.getWriteMethod();
        Attribute attribute2 = attribute = readMethod != null ? readMethod.getAnnotation(Attribute.class) : null;
        if (attribute == null) {
            attribute = writeMethod != null ? writeMethod.getAnnotation(Attribute.class) : null;
        }
        return attribute;
    }

    @Nonnull
    protected AttributeDefinition<?, ?> generateDefinitionFor(@Nonnull PropertyDescriptor descriptor, @Nonnull Attribute attribute) {
        ReflectionBasedAttributeDefinition<Object, Object> definition = new ReflectionBasedAttributeDefinition<Object, Object>(descriptor);
        definition.setName(attribute.name());
        definition.setDescription(attribute.description());
        definition.setAccessMode(attribute.accessMode());
        Class<? extends AttributeAccessor<?, ?>> accessorType = attribute.accessor();
        if (!Attribute.Null.class.equals(accessorType)) {
            definition.setAccessor(this.createInvoker(accessorType));
        }
        return definition;
    }

    @Nonnull
    protected AttributeAccessor<Object, Object> createInvoker(@Nonnull Class<? extends AttributeAccessor<?, ?>> accessorType) {
        try {
            return accessorType.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create new instance of '" + accessorType + "'.", e);
        }
    }
}

