/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jemoni.jmx.reflection;

import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import org.echocat.jemoni.jmx.AttributeDefinition;
import org.echocat.jemoni.jmx.AttributeDefinitionDiscovery;
import org.echocat.jemoni.jmx.BeanDefinition;
import org.echocat.jemoni.jmx.BeanDefinitionDiscovery;
import org.echocat.jemoni.jmx.OperationDefinition;
import org.echocat.jemoni.jmx.OperationDefinitionDiscovery;
import org.echocat.jemoni.jmx.annotations.Bean;
import org.echocat.jemoni.jmx.reflection.ReflectionBasedAttributeDefinitionDiscovery;
import org.echocat.jemoni.jmx.reflection.ReflectionBasedBeanDefinition;
import org.echocat.jemoni.jmx.reflection.ReflectionBasedOperationDefinitionDiscovery;

public class ReflectionBasedBeanDefinitionDiscovery
implements BeanDefinitionDiscovery {
    private static final ReflectionBasedBeanDefinitionDiscovery INSTANCE = new ReflectionBasedBeanDefinitionDiscovery();
    private OperationDefinitionDiscovery _operationDefinitionDiscovery = ReflectionBasedOperationDefinitionDiscovery.reflectionBasedOperationDefinitionDiscovery();
    private AttributeDefinitionDiscovery _attributeDefinitionDiscovery = ReflectionBasedAttributeDefinitionDiscovery.reflectionBasedAttributeDefinitionDiscovery();
    private final Map<Class<?>, BeanDefinition<?>> _typeToDefinitionsCache = new WeakHashMap();

    public static ReflectionBasedBeanDefinitionDiscovery reflectionBasedBeanDefinitionDiscovery() {
        return INSTANCE;
    }

    @Nonnull
    public OperationDefinitionDiscovery getOperationDefinitionDiscovery() {
        return this._operationDefinitionDiscovery;
    }

    public void setOperationDefinitionDiscovery(@Nonnull OperationDefinitionDiscovery operationDefinitionDiscovery) {
        this.checkForModificationsOnDefaultInstance();
        this._operationDefinitionDiscovery = operationDefinitionDiscovery;
    }

    @Nonnull
    public AttributeDefinitionDiscovery getAttributeDefinitionDiscovery() {
        return this._attributeDefinitionDiscovery;
    }

    public void setAttributeDefinitionDiscovery(@Nonnull AttributeDefinitionDiscovery attributeDefinitionDiscovery) {
        this.checkForModificationsOnDefaultInstance();
        this._attributeDefinitionDiscovery = attributeDefinitionDiscovery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public <B> BeanDefinition<B> discoverFor(@Nonnull Class<B> beanType) {
        BeanDefinition<Object> result;
        Map<Class<?>, BeanDefinition<?>> map = this._typeToDefinitionsCache;
        synchronized (map) {
            result = this._typeToDefinitionsCache.get(beanType);
        }
        if (result == null) {
            result = this.generateDefinitionsFor(beanType);
            map = this._typeToDefinitionsCache;
            synchronized (map) {
                this._typeToDefinitionsCache.put(beanType, result);
            }
        }
        return result;
    }

    @Nonnull
    protected <B> BeanDefinition<B> generateDefinitionsFor(@Nonnull Class<B> beanType) {
        Set<OperationDefinition<B>> operations = this._operationDefinitionDiscovery.discoverFor(beanType);
        Set<AttributeDefinition<?, B>> attributes = this._attributeDefinitionDiscovery.discoverFor(beanType);
        ReflectionBasedBeanDefinition<B> result = new ReflectionBasedBeanDefinition<B>(operations, attributes);
        Bean bean = beanType.getAnnotation(Bean.class);
        if (bean != null) {
            result.setDescription(bean.description());
        }
        return result;
    }

    private void checkForModificationsOnDefaultInstance() {
        if (this == INSTANCE) {
            throw new UnsupportedOperationException("Modifying of default instance of " + this.getClass().getName() + " is not supported.");
        }
    }
}

