/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jemoni.jmx.reflection;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import org.echocat.jemoni.jmx.OperationDefinition;
import org.echocat.jemoni.jmx.OperationDefinitionDiscovery;
import org.echocat.jemoni.jmx.OperationInvoker;
import org.echocat.jemoni.jmx.annotations.Operation;
import org.echocat.jemoni.jmx.reflection.ReflectionBasedOperationDefinition;

public class ReflectionBasedOperationDefinitionDiscovery
implements OperationDefinitionDiscovery {
    private static final ReflectionBasedOperationDefinitionDiscovery INSTANCE = new ReflectionBasedOperationDefinitionDiscovery();
    private final Map<Class<?>, Set<OperationDefinition<?>>> _typeToDefinitionsCache = new WeakHashMap();

    @Nonnull
    public static ReflectionBasedOperationDefinitionDiscovery reflectionBasedOperationDefinitionDiscovery() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public <B> Set<OperationDefinition<B>> discoverFor(@Nonnull Class<B> beanType) {
        Set<OperationDefinition<Object>> result;
        Map<Class<?>, Set<OperationDefinition<?>>> map = this._typeToDefinitionsCache;
        synchronized (map) {
            result = this._typeToDefinitionsCache.get(beanType);
        }
        if (result == null) {
            result = this.generateDefinitionsFor(beanType);
            map = this._typeToDefinitionsCache;
            synchronized (map) {
                this._typeToDefinitionsCache.put(beanType, result);
            }
        }
        return result;
    }

    @Nonnull
    protected Set<OperationDefinition<?>> generateDefinitionsFor(@Nonnull Class<?> beanType) {
        HashSet result = new HashSet();
        for (Method method : beanType.getMethods()) {
            Operation operation = method.getAnnotation(Operation.class);
            if (operation == null) continue;
            result.add(this.generateDefinitionFor(method, operation));
        }
        return Collections.unmodifiableSet(result);
    }

    @Nonnull
    protected OperationDefinition<?> generateDefinitionFor(@Nonnull Method method, @Nonnull Operation operation) {
        ReflectionBasedOperationDefinition<Object> definition = new ReflectionBasedOperationDefinition<Object>(method);
        definition.setName(operation.name());
        definition.setDescription(operation.description());
        Class<? extends OperationInvoker<?>> invoker = operation.invoker();
        if (!Operation.Null.class.equals(invoker)) {
            definition.setInvoker(this.createInvoker(invoker));
        }
        return definition;
    }

    @Nonnull
    protected OperationInvoker<Object> createInvoker(@Nonnull Class<? extends OperationInvoker<?>> invoker) {
        try {
            return invoker.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create new instance of '" + invoker + "'.", e);
        }
    }
}

