/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jemoni.jmx.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.echocat.jemoni.jmx.support.InetAddressMatcher;
import org.echocat.jemoni.jmx.support.ServletHealth;
import org.echocat.jemoni.jmx.support.ServletHealthInterceptorAdapter;
import org.echocat.jomon.cache.Cache;
import org.echocat.jomon.cache.ClearableCache;
import org.echocat.jomon.cache.LruCache;
import org.echocat.jomon.cache.management.CacheDefinition;
import org.echocat.jomon.cache.management.CacheProvider;
import org.echocat.jomon.cache.management.DefaultCacheDefinition;
import org.echocat.jomon.runtime.util.ValueProducer;

public class AllowedHostsServletHealthInterceptor
extends ServletHealthInterceptorAdapter {
    private static final Pattern ADDRESS_AND_BITS_EXTRACT_PATTERN = Pattern.compile("([^/]*)(?:|/(\\d+))");
    private final Cache<String, Boolean> _addressToAllowed;
    private final ValueProducer<String, Boolean> _addressToAllowedProducer = new ValueProducer<String, Boolean>(){

        @Nonnull
        public Boolean produce(@Nonnull String remoteAddress) throws Exception {
            return AllowedHostsServletHealthInterceptor.this.isRespectedByIncludes(remoteAddress) && !AllowedHostsServletHealthInterceptor.this.isRespectedByExcludes(remoteAddress);
        }
    };
    private Collection<InetAddressMatcher> _includes;
    private Collection<InetAddressMatcher> _excludes;

    public AllowedHostsServletHealthInterceptor() {
        this(null);
    }

    public AllowedHostsServletHealthInterceptor(@Nullable CacheProvider cacheProvider) {
        this._addressToAllowed = cacheProvider != null ? cacheProvider.provide(AllowedHostsServletHealthInterceptor.class, "addressToAllowed", (CacheDefinition)DefaultCacheDefinition.lruCache(String.class, Boolean.class).withCapacity(1000L)) : this.createFallBackCache();
    }

    @Override
    public boolean isRecordAllowed(@Nonnull ServletRequest request, @Nonnull ServletHealth.ScopeMapping globalMapping, @Nullable ServletHealth.ScopeMapping specificMapping) {
        String remoteAddress = request.getRemoteAddr();
        return (Boolean)this._addressToAllowed.get((Object)remoteAddress, this._addressToAllowedProducer);
    }

    protected boolean isRespectedByIncludes(@Nonnull String address) {
        return this.isRespectedBy(this._includes, address, true);
    }

    protected boolean isRespectedByExcludes(@Nonnull String address) {
        return this.isRespectedBy(this._excludes, address, false);
    }

    protected boolean isRespectedBy(@Nullable Collection<InetAddressMatcher> matches, @Nonnull String address, boolean fallbackValue) {
        boolean result;
        if (matches != null) {
            result = false;
            for (InetAddressMatcher include : matches) {
                if (!include.matches(address)) continue;
                result = true;
                break;
            }
        } else {
            result = fallbackValue;
        }
        return result;
    }

    public Collection<InetAddressMatcher> getIncludes() {
        return this._includes;
    }

    public void setIncludes(Collection<InetAddressMatcher> includes) {
        this._includes = includes;
        if (this._addressToAllowed instanceof ClearableCache) {
            ((ClearableCache)this._addressToAllowed).clear();
        }
    }

    public Collection<InetAddressMatcher> getExcludes() {
        return this._excludes;
    }

    public void setExcludes(Collection<InetAddressMatcher> excludes) {
        this._excludes = excludes;
        if (this._addressToAllowed instanceof ClearableCache) {
            ((ClearableCache)this._addressToAllowed).clear();
        }
    }

    public String getIncludesPattern() {
        return this.toPattern(this.getIncludes());
    }

    public void setIncludesPattern(String pattern) {
        this.setIncludes(this.parseMatchersBy(pattern));
    }

    public String getExcludesPattern() {
        return this.toPattern(this.getExcludes());
    }

    public void setExcludesPattern(String pattern) {
        this.setExcludes(this.parseMatchersBy(pattern));
    }

    @Nullable
    protected Collection<InetAddressMatcher> parseMatchersBy(@Nullable String pattern) throws IllegalArgumentException {
        ArrayList<InetAddressMatcher> matches;
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            matches = null;
        } else {
            String[] patternParts;
            matches = new ArrayList<InetAddressMatcher>();
            for (String patternPart : patternParts = StringUtils.split((String)pattern, (String)",;")) {
                String trimmedPatternPart = patternPart.trim();
                if (trimmedPatternPart.isEmpty()) continue;
                matches.add(this.parseMatcherBy(patternPart));
            }
        }
        return matches;
    }

    @Nullable
    protected String toPattern(@Nullable Collection<InetAddressMatcher> matchers) {
        String result;
        if (matchers == null) {
            result = null;
        } else {
            StringBuilder sb = new StringBuilder();
            for (InetAddressMatcher matcher : matchers) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(matcher.getAddress().getHostAddress());
                int bits = matcher.getBits();
                if (bits <= 0) continue;
                sb.append('/').append(bits);
            }
            result = sb.toString();
        }
        return result;
    }

    @Nonnull
    protected InetAddressMatcher parseMatcherBy(@Nonnull String pattern) {
        int bits;
        Matcher regexMatcher = ADDRESS_AND_BITS_EXTRACT_PATTERN.matcher(pattern);
        if (!regexMatcher.matches()) {
            throw new IllegalArgumentException("Pattern does not match required syntax \"<host>[/<bits>][,...]\": " + pattern);
        }
        String host = regexMatcher.group(1);
        String plainBits = regexMatcher.group(2);
        try {
            bits = StringUtils.isEmpty((CharSequence)plainBits) ? 0 : Integer.valueOf(plainBits);
        }
        catch (NumberFormatException ignored) {
            throw new IllegalArgumentException("Illegal pattern: " + pattern);
        }
        return InetAddressMatcher.matcher(host, bits);
    }

    @Nonnull
    protected Cache<String, Boolean> createFallBackCache() {
        LruCache cache = new LruCache(String.class, Boolean.class);
        cache.setCapacity(Long.valueOf(1000L));
        return cache;
    }
}

