/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jemoni.jmx.support;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import org.echocat.jemoni.jmx.JmxRegistry;
import org.echocat.jemoni.jmx.Registration;
import org.echocat.jomon.cache.CacheListener;
import org.echocat.jomon.cache.LocalTrackingEnabledCacheListener;

public class CacheListenerMBean
implements DynamicMBean,
AutoCloseable {
    private static final DecimalFormatSymbols DECIMAL_FORMAT_SYMBOLS = DecimalFormatSymbols.getInstance(Locale.US);
    private final CacheListener _listener;
    private final Registration _registration;

    public CacheListenerMBean(@Nonnull CacheListener listener, @Nonnull JmxRegistry registry) {
        this._listener = listener;
        this._registration = registry.register((DynamicMBean)this, this._listener.getClass());
    }

    @Override
    public void close() throws Exception {
        this._registration.close();
    }

    @Override
    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (!"numberOfLocalTrackedEvents".equals(attributeName)) {
            throw new AttributeNotFoundException();
        }
        Integer result = this.castForAttribute(LocalTrackingEnabledCacheListener.class).getNumberOfLocalTrackedEvents();
        return result;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        String attributeName = attribute.getName();
        Object value = attribute.getValue();
        if (!"numberOfLocalTrackedEvents".equals(attributeName)) {
            throw new AttributeNotFoundException();
        }
        this.castForAttribute(LocalTrackingEnabledCacheListener.class).setNumberOfLocalTrackedEvents(this.cast(Number.class, value).intValue());
    }

    private <T> T cast(@Nonnull Class<T> type, @Nullable Object value) throws InvalidAttributeValueException {
        if (!type.isInstance(value)) {
            throw new InvalidAttributeValueException();
        }
        return type.cast(value);
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        StringBuilder sb;
        if ("getReport".equals(actionName)) {
            DecimalFormat full = new DecimalFormat("#,##0", DECIMAL_FORMAT_SYMBOLS);
            DecimalFormat part = new DecimalFormat("#,##0.00", DECIMAL_FORMAT_SYMBOLS);
            Collection reports = this.castForOperation(LocalTrackingEnabledCacheListener.class).getReports();
            sb = new StringBuilder();
            for (LocalTrackingEnabledCacheListener.Report report : reports) {
                if (sb.length() > 0) {
                    sb.append("\n====================================================================================================================\n");
                }
                sb.append('[').append(report.getEvent()).append("] ").append(full.format(report.getNumberOfInvocations())).append(" total, ").append(part.format(report.getNumberOfInvocationsPerSecond())).append(" i/s");
                for (StackTraceElement stackTraceElement : report.getStackTrace()) {
                    sb.append("\n\tat ").append(stackTraceElement);
                }
            }
        } else {
            throw new UnsupportedOperationException();
        }
        String result = sb.toString();
        return result;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return new MBeanInfo(this._listener.getClass().getName(), null, this.getAttributesArray(), null, this.getOperationsArray(), null);
    }

    @Nonnull
    protected MBeanAttributeInfo[] getAttributesArray() {
        List<MBeanAttributeInfo> result = this.getAttributes();
        return result.toArray(new MBeanAttributeInfo[result.size()]);
    }

    @Nonnull
    protected List<MBeanAttributeInfo> getAttributes() {
        ArrayList<MBeanAttributeInfo> result = new ArrayList<MBeanAttributeInfo>();
        if (this._listener instanceof LocalTrackingEnabledCacheListener) {
            result.add(new MBeanAttributeInfo("numberOfLocalTrackedEvents", Integer.class.getName(), null, true, true, false));
        }
        return result;
    }

    @Nonnull
    protected MBeanOperationInfo[] getOperationsArray() {
        List<MBeanOperationInfo> result = this.getOperations();
        return result.toArray(new MBeanOperationInfo[result.size()]);
    }

    @Nonnull
    protected List<MBeanOperationInfo> getOperations() {
        ArrayList<MBeanOperationInfo> result = new ArrayList<MBeanOperationInfo>();
        if (this._listener instanceof LocalTrackingEnabledCacheListener) {
            result.add(new MBeanOperationInfo("getReport", null, new MBeanParameterInfo[0], String.class.getName(), 1));
        }
        return result;
    }

    @Nonnull
    protected <T extends CacheListener> T castForAttribute(@Nonnull Class<T> type) throws AttributeNotFoundException {
        if (type.isInstance(this._listener)) {
            return (T)((CacheListener)type.cast(this._listener));
        }
        throw new AttributeNotFoundException();
    }

    @Nonnull
    protected <T extends CacheListener> T castForOperation(@Nonnull Class<T> type) throws MBeanException {
        if (type.isInstance(this._listener)) {
            return (T)((CacheListener)type.cast(this._listener));
        }
        throw new MBeanException(null, "Illegal method.");
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        throw new UnsupportedOperationException();
    }
}

