/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jemoni.jmx.support;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
@Immutable
public class InetAddressMatcher {
    private final InetAddress _address;
    private final int _bits;
    private final int _numberOfFirstBitsThatHaveToMatch;
    private final InetAddress _mask;

    @Nonnull
    public static InetAddressMatcher matcher(@Nonnull String host) throws IllegalArgumentException {
        return InetAddressMatcher.matcher(host, 0);
    }

    @Nonnull
    public static InetAddressMatcher matcher(@Nonnull String host, @Nonnegative int bits) throws IllegalArgumentException {
        return new InetAddressMatcher(host, bits);
    }

    @Nonnull
    public static InetAddressMatcher matcher(@Nonnull InetAddress address) throws IllegalArgumentException {
        return InetAddressMatcher.matcher(address, 0);
    }

    @Nonnull
    public static InetAddressMatcher matcher(@Nonnull InetAddress address, @Nonnegative int bits) throws IllegalArgumentException {
        return new InetAddressMatcher(address, bits);
    }

    public InetAddressMatcher(@Nonnull String host, @Nonnegative int bits) throws IllegalArgumentException {
        this(InetAddressMatcher.resolveHost(host), bits);
    }

    public InetAddressMatcher(@Nonnull InetAddress address, @Nonnegative int bits) {
        this._address = address;
        this._bits = bits;
        this._mask = this.buildMaskFrom(address, bits);
        this._numberOfFirstBitsThatHaveToMatch = this._mask.getAddress().length * 8 - this._bits;
    }

    public boolean matches(@Nullable String host) throws IllegalArgumentException {
        return host != null && this.matches(InetAddressMatcher.resolveHost(host));
    }

    public boolean matches(@Nullable InetAddress that) {
        return that != null && this.matches(that.getAddress());
    }

    public boolean matches(@Nullable byte[] address) {
        byte[] mask;
        boolean result = address != null ? (address.length == (mask = this._mask.getAddress()).length ? this.matches(address, mask) : false) : false;
        return result;
    }

    protected boolean matches(@Nonnull byte[] left, @Nonnull byte[] right) {
        boolean result = left.length == right.length;
        for (int c = 0; result && c < this._numberOfFirstBitsThatHaveToMatch; ++c) {
            int i = c / 8;
            int bit = 1 << c % 8;
            result = (left[i] & bit) == (right[i] & bit);
        }
        return result;
    }

    @Nonnull
    public InetAddress getAddress() {
        return this._address;
    }

    @Nonnegative
    public int getBits() {
        return this._bits;
    }

    @Nonnull
    public InetAddress getMask() {
        return this._mask;
    }

    @Nonnull
    protected InetAddress buildMaskFrom(@Nonnull InetAddress address, @Nonnegative int lastMaskedBits) {
        try {
            return InetAddress.getByAddress(this.buildMaskFrom(address.getAddress(), lastMaskedBits));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Could not create a mask from " + address.getHostAddress() + "/" + this._bits, e);
        }
    }

    @Nonnull
    protected byte[] buildMaskFrom(@Nonnull byte[] address, @Nonnegative int lastMaskedBits) {
        byte[] mask = new byte[address.length];
        int numberOfTotalBits = mask.length * 8;
        for (int c = 0; c < numberOfTotalBits - lastMaskedBits; ++c) {
            int i = c / 8;
            int bit = 1 << c % 8;
            if ((address[i] & bit) != bit) continue;
            mask[i] = (byte)(mask[i] | 1 << c % 8);
        }
        return mask;
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            result = true;
        } else if (!(o instanceof InetAddressMatcher)) {
            result = false;
        } else {
            InetAddressMatcher that = (InetAddressMatcher)o;
            result = this.getMask().equals(that.getMask()) && this.getBits() == that.getBits();
        }
        return result;
    }

    public int hashCode() {
        return this.getMask().hashCode() * this.getBits();
    }

    public String toString() {
        return this.getAddress().getHostAddress() + "/" + this._bits + "(" + this.getMask().getHostAddress() + ")";
    }

    @Nonnull
    protected static InetAddress resolveHost(@Nonnull String host) throws IllegalArgumentException {
        try {
            return InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("The given host could not be resolved.", e);
        }
    }
}

