/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jemoni.jmx.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections15.map.LRUMap;
import org.apache.commons.lang3.StringUtils;
import org.echocat.jemoni.jmx.JmxRegistry;
import org.echocat.jemoni.jmx.Registration;
import org.echocat.jemoni.jmx.support.AllowedHostsServletHealthInterceptor;
import org.echocat.jemoni.jmx.support.CombinedServletHealthInterceptor;
import org.echocat.jemoni.jmx.support.ServletHealthInterceptor;
import org.echocat.jemoni.jmx.support.SpringUtils;
import org.echocat.jomon.runtime.concurrent.StopWatch;
import org.echocat.jomon.runtime.iterators.ConvertingIterator;
import org.echocat.jomon.runtime.math.OverPeriodAverageDoubleCounter;
import org.echocat.jomon.runtime.math.OverPeriodCounter;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.jomon.runtime.util.Entry;
import org.echocat.jomon.runtime.util.ResourceUtils;

public class ServletHealth
implements AutoCloseable,
Filter,
Iterable<Entry<Pattern, ScopeMapping>> {
    public static final String MAPPING_INIT_ATTRIBUTE = "mapping";
    public static final String REGISTRY_REF_INIT_ATTRIBUTE = "registry-ref";
    public static final String EXCLUDES_HOSTS = "excludeHosts";
    public static final String INCLUDES_HOSTS = "includeHosts";
    public static final String INTERCEPTOR_INIT_ATTRIBUTE = "interceptor";
    public static final String INTERCEPTOR_REF_INIT_ATTRIBUTE = "interceptor-ref";
    public static final String REQUESTS_PER_SECOND_ATTRIBUTE_NAME = "requestsPerSecond";
    public static final String AVERAGE_REQUEST_DURATION_ATTRIBUTE_NAME = "averageRequestDuration";
    public static final String CURRENT_REQUEST_STOP_WATCH_ATTRIBUTE_NAME = ServletHealth.class.getName() + ".currentRequestStopWatch";
    private final Map<String, ScopeMapping> _pathToMappingCache = new LRUMap(10000);
    private JmxRegistry _registry;
    private Map<Pattern, ScopeMapping> _patternToMapping;
    private Map<String, ScopeMapping> _nameToMapping;
    private ServletHealthInterceptor _interceptor;
    private Registration _registration;

    public ServletHealth() {
        this.setMapping(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMapping(@Nullable String mappingAsString) {
        LinkedHashMap<Pattern, ScopeMapping> patternToMapping = new LinkedHashMap<Pattern, ScopeMapping>();
        ServletHealthInterceptor interceptor = this._interceptor;
        if (mappingAsString != null) {
            for (String parts : mappingAsString.split("[,\\n\\r]")) {
                String trimmedPart = parts.trim();
                if (trimmedPart.isEmpty()) continue;
                int lastArrow = trimmedPart.lastIndexOf(62);
                if (lastArrow > 0 && lastArrow + 1 < trimmedPart.length()) {
                    try {
                        Pattern pattern = Pattern.compile(trimmedPart.substring(0, lastArrow).trim());
                        String name = trimmedPart.substring(lastArrow + 1).trim();
                        if (name.isEmpty()) {
                            throw new IllegalArgumentException("Illegal formatted mapping: " + mappingAsString);
                        }
                        Collection<String> possibleSpecificNames = interceptor != null ? interceptor.getPossibleNames(name) : null;
                        patternToMapping.put(pattern, new ScopeMapping(name, possibleSpecificNames));
                        continue;
                    }
                    catch (PatternSyntaxException e) {
                        throw new IllegalArgumentException("Illegal formatted mapping: " + mappingAsString, e);
                    }
                }
                throw new IllegalArgumentException("Illegal formatted mapping: " + mappingAsString);
            }
        }
        patternToMapping.put(null, new ScopeMapping(null, Collections.emptyList()));
        this._nameToMapping = this.asNameToMapping(patternToMapping.values());
        this._patternToMapping = Collections.unmodifiableMap(patternToMapping);
        Map<String, ScopeMapping> map = this._pathToMappingCache;
        synchronized (map) {
            this._pathToMappingCache.clear();
        }
    }

    @Nullable
    public String getMapping() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Pattern, ScopeMapping> patternAndMapping : this._patternToMapping.entrySet()) {
            if (patternAndMapping.getKey() == null) continue;
            if (sb.length() > 0) {
                sb.append(",\n");
            }
            sb.append(patternAndMapping.getKey()).append('>').append(patternAndMapping.getValue().getDefaultName());
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    public ServletHealthInterceptor getInterceptor() {
        return this._interceptor;
    }

    public void setInterceptor(ServletHealthInterceptor interceptor) {
        this._interceptor = interceptor;
        this.setMapping(this.getMapping());
    }

    public void setRegistry(@Nullable JmxRegistry registry) {
        this._registry = registry;
    }

    @Nonnull
    public JmxRegistry getRegistry() {
        JmxRegistry registry = this._registry;
        return registry != null ? registry : JmxRegistry.getLocalInstance();
    }

    @Nonnull
    protected Map<String, ScopeMapping> asNameToMapping(@Nonnull Iterable<ScopeMapping> values) {
        LinkedHashMap<String, ScopeMapping> result = new LinkedHashMap<String, ScopeMapping>();
        for (ScopeMapping mapping : values) {
            for (String name : mapping.getAllNames()) {
                result.put(name, mapping);
            }
        }
        return Collections.unmodifiableMap(result);
    }

    public void init() {
        this._registration = this.getRegistry().register((DynamicMBean)new MBeanInformation(), this.getClass());
    }

    public void init(@Nonnull FilterConfig filterConfig) throws ServletException {
        String interceptorRef;
        String interceptor;
        String registryRef;
        String mapping = filterConfig.getInitParameter(MAPPING_INIT_ATTRIBUTE);
        if (mapping != null) {
            this.setMapping(mapping);
        }
        if (!StringUtils.isEmpty((CharSequence)(registryRef = filterConfig.getInitParameter(REGISTRY_REF_INIT_ATTRIBUTE)))) {
            this.setRegistry(SpringUtils.getBeanFor(filterConfig.getServletContext(), registryRef, JmxRegistry.class));
        }
        if (!StringUtils.isEmpty((CharSequence)(interceptor = filterConfig.getInitParameter(INTERCEPTOR_INIT_ATTRIBUTE)))) {
            this.setInterceptor(this.loadInterceptor(interceptor));
        }
        if (!StringUtils.isEmpty((CharSequence)(interceptorRef = filterConfig.getInitParameter(INTERCEPTOR_REF_INIT_ATTRIBUTE)))) {
            this.setInterceptor(SpringUtils.getBeanFor(filterConfig.getServletContext(), interceptorRef, ServletHealthInterceptor.class));
        }
        this.handleHostIncludeExcludesIfNeeded(filterConfig);
        this.init();
    }

    protected void handleHostIncludeExcludesIfNeeded(@Nonnull FilterConfig filterConfig) {
        String includeHosts = filterConfig.getInitParameter(INCLUDES_HOSTS);
        String excludeHosts = filterConfig.getInitParameter(EXCLUDES_HOSTS);
        if (!StringUtils.isEmpty((CharSequence)includeHosts) || !StringUtils.isEmpty((CharSequence)excludeHosts)) {
            ServletHealthInterceptor originalInterceptor = this.getInterceptor();
            AllowedHostsServletHealthInterceptor newInterceptor = new AllowedHostsServletHealthInterceptor();
            newInterceptor.setIncludesPattern(includeHosts);
            newInterceptor.setExcludesPattern(excludeHosts);
            this.setInterceptor(originalInterceptor != null ? new CombinedServletHealthInterceptor(originalInterceptor, newInterceptor) : newInterceptor);
        }
    }

    @Nonnull
    public ServletHealthInterceptor loadInterceptor(@Nonnull String interceptorTypeName) throws ServletException {
        Class<?> interceptorType;
        try {
            interceptorType = Thread.currentThread().getContextClassLoader().loadClass(interceptorTypeName);
        }
        catch (ClassNotFoundException e) {
            throw new ServletException("Could not find interceptor of type " + interceptorTypeName + ".", (Throwable)e);
        }
        if (!ServletHealthInterceptor.class.isAssignableFrom(interceptorType)) {
            throw new ServletException("Defined interceptor type " + interceptorTypeName + " does not implements " + ServletHealthInterceptor.class.getName() + ".");
        }
        try {
            return (ServletHealthInterceptor)interceptorType.newInstance();
        }
        catch (Exception e) {
            throw new ServletException("Could not create an instance of interceptor " + interceptorType.getName() + ".", (Throwable)e);
        }
    }

    @Override
    public void close() {
        try {
            ResourceUtils.closeQuietly((AutoCloseable)this._registration);
        }
        finally {
            this._registration = null;
        }
    }

    public void destroy() {
        this.close();
    }

    @Override
    @Nonnull
    public Iterator<Entry<Pattern, ScopeMapping>> iterator() {
        return new ConvertingIterator<Map.Entry<Pattern, ScopeMapping>, Entry<Pattern, ScopeMapping>>(this._patternToMapping.entrySet().iterator()){

            protected Entry<Pattern, ScopeMapping> convert(Map.Entry<Pattern, ScopeMapping> input) {
                return new Entry.Impl((Object)input.getKey(), (Object)input.getValue());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(@Nonnull ServletRequest request, @Nonnull ServletResponse response, @Nonnull FilterChain chain) throws IOException, ServletException {
        StopWatch stopWatch = new StopWatch();
        request.setAttribute(CURRENT_REQUEST_STOP_WATCH_ATTRIBUTE_NAME, (Object)stopWatch);
        ScopeMapping globalMapping = this._patternToMapping.get(null);
        ScopeMapping specificMapping = request instanceof HttpServletRequest ? this.getMappingFor(((HttpServletRequest)request).getRequestURI()) : null;
        try {
            chain.doFilter(request, response);
        }
        catch (Throwable throwable) {
            request.removeAttribute(CURRENT_REQUEST_STOP_WATCH_ATTRIBUTE_NAME);
            Duration duration = stopWatch.getCurrentDuration();
            ServletHealthInterceptor interceptor = this._interceptor;
            if (interceptor == null || interceptor.isRecordAllowed(request, globalMapping, specificMapping)) {
                globalMapping.record(null, duration);
                if (specificMapping != null) {
                    String targetName = interceptor != null ? interceptor.getSpecificTargetName(request, specificMapping) : null;
                    specificMapping.record(targetName, duration);
                }
            }
            throw throwable;
        }
        request.removeAttribute(CURRENT_REQUEST_STOP_WATCH_ATTRIBUTE_NAME);
        Duration duration = stopWatch.getCurrentDuration();
        ServletHealthInterceptor interceptor = this._interceptor;
        if (interceptor == null || interceptor.isRecordAllowed(request, globalMapping, specificMapping)) {
            globalMapping.record(null, duration);
            if (specificMapping != null) {
                String targetName = interceptor != null ? interceptor.getSpecificTargetName(request, specificMapping) : null;
                specificMapping.record(targetName, duration);
            }
        }
    }

    @Nullable
    public static Duration findCurrentRequestDurationOf(@Nonnull ServletRequest request) {
        Object plainStopWatch = request.getAttribute(CURRENT_REQUEST_STOP_WATCH_ATTRIBUTE_NAME);
        return plainStopWatch instanceof StopWatch ? ((StopWatch)plainStopWatch).getCurrentDuration() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected ScopeMapping getMappingFor(@Nonnull String path) {
        ScopeMapping mapping;
        Map<String, ScopeMapping> map = this._pathToMappingCache;
        synchronized (map) {
            mapping = this._pathToMappingCache.get(path);
        }
        if (mapping == null) {
            for (Map.Entry entry : this._patternToMapping.entrySet()) {
                Pattern pattern = (Pattern)entry.getKey();
                if (pattern == null || !pattern.matcher(path).matches()) continue;
                mapping = (ScopeMapping)entry.getValue();
                break;
            }
            map = this._pathToMappingCache;
            synchronized (map) {
                this._pathToMappingCache.put(path, mapping);
            }
        }
        return mapping;
    }

    @Nullable
    protected ScopeMapping getMapping(@Nonnull String defaultName) {
        return this._nameToMapping.get(defaultName);
    }

    protected class MBeanInformation
    implements DynamicMBean {
        protected MBeanInformation() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
            int firstDot = name.indexOf(46);
            boolean withPrefix = firstDot > 0 && firstDot + 1 < name.length();
            String mappingName = withPrefix ? name.substring(0, firstDot) : null;
            String valueName = withPrefix ? name.substring(firstDot + 1) : name;
            ScopeMapping mapping = (ScopeMapping)ServletHealth.this._nameToMapping.get(mappingName);
            if (mapping == null) throw new AttributeNotFoundException();
            if (ServletHealth.REQUESTS_PER_SECOND_ATTRIBUTE_NAME.equals(valueName)) {
                return mapping.getRequestsPerSecond(mappingName);
            }
            if (!ServletHealth.AVERAGE_REQUEST_DURATION_ATTRIBUTE_NAME.equals(valueName)) throw new AttributeNotFoundException();
            return mapping.getAverageRequestDuration(mappingName);
        }

        @Nonnull
        protected MBeanAttributeInfo[] getMBeanAttributesFor() {
            ArrayList<MBeanAttributeInfo> attributes = new ArrayList<MBeanAttributeInfo>();
            for (ScopeMapping mapping : ServletHealth.this._patternToMapping.values()) {
                for (String name : mapping.getAllNames()) {
                    attributes.add(new MBeanAttributeInfo(name != null ? name + "." + ServletHealth.REQUESTS_PER_SECOND_ATTRIBUTE_NAME : ServletHealth.REQUESTS_PER_SECOND_ATTRIBUTE_NAME, Double.class.getName(), null, true, false, false));
                    attributes.add(new MBeanAttributeInfo(name != null ? name + "." + ServletHealth.AVERAGE_REQUEST_DURATION_ATTRIBUTE_NAME : ServletHealth.AVERAGE_REQUEST_DURATION_ATTRIBUTE_NAME, Double.class.getName(), null, true, false, false));
                }
            }
            return attributes.toArray(new MBeanAttributeInfo[attributes.size()]);
        }

        @Override
        public MBeanInfo getMBeanInfo() {
            return new MBeanInfo(ServletHealth.this.getClass().getName(), "Display basic information of servlet handling.", this.getMBeanAttributesFor(), null, null, null);
        }

        @Override
        public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
            throw new AttributeNotFoundException();
        }

        @Override
        public AttributeList getAttributes(String[] attributes) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AttributeList setAttributes(AttributeList attributes) {
            throw new UnsupportedOperationException();
        }
    }

    public static class MeasurePoints {
        private final OverPeriodCounter _requestsPerSecond = new OverPeriodCounter(new Duration("1m"), new Duration("1s"));
        private final OverPeriodAverageDoubleCounter _averageRequestDuration = new OverPeriodAverageDoubleCounter(new Duration("1m"), new Duration("1s"));

        public void record(@Nonnull Duration requestDuration) {
            this._requestsPerSecond.record();
            this._averageRequestDuration.record((Object)requestDuration.toMilliSeconds());
        }

        @Nonnegative
        public double getAverageRequestDuration() {
            return (Double)this._averageRequestDuration.get();
        }

        @Nonnegative
        public double getRequestsPerSecond() {
            return this._requestsPerSecond.getAsDouble();
        }
    }

    public static class ScopeMapping {
        private final Map<String, MeasurePoints> _nameToMeasurePoints;
        private final String _defaultName;

        public ScopeMapping(@Nullable String defaultName, @Nullable Collection<String> names) {
            this._defaultName = defaultName;
            this._nameToMeasurePoints = new LinkedHashMap<String, MeasurePoints>();
            if (names == null || names.isEmpty()) {
                this._nameToMeasurePoints.put(defaultName, new MeasurePoints());
            } else {
                for (String possibleSpecificName : names) {
                    this._nameToMeasurePoints.put(possibleSpecificName, new MeasurePoints());
                }
            }
        }

        @Nullable
        public String getDefaultName() {
            return this._defaultName;
        }

        @Nonnull
        public Collection<String> getAllNames() {
            return Collections.unmodifiableCollection(this._nameToMeasurePoints.keySet());
        }

        @Nonnegative
        public double getAverageRequestDuration(@Nonnull String name) {
            return this._nameToMeasurePoints.get(name).getAverageRequestDuration();
        }

        @Nonnegative
        public double getRequestsPerSecond(@Nonnull String name) {
            return this._nameToMeasurePoints.get(name).getRequestsPerSecond();
        }

        public void record(@Nullable String targetName, @Nonnull Duration requestDuration) {
            String name = targetName != null ? targetName : this._defaultName;
            MeasurePoints measurePoints = this._nameToMeasurePoints.get(name);
            if (measurePoints == null) {
                throw new IllegalStateException("Used a name that is unknown: " + name);
            }
            measurePoints.record(requestDuration);
        }
    }
}

