/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jemoni.jmx.support;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;

public class SpringUtils {
    private static final Class<?> WEB_APPLICATION_CONTEXT_UTILS = SpringUtils.findClass("org.springframework.web.context.support.WebApplicationContextUtils");
    private static final Class<?> WEB_APPLICATION_CONTEXT = SpringUtils.findClass("org.springframework.web.context.WebApplicationContext");
    private static final Method GET_WEB_APPLICATION_CONTEXT = SpringUtils.getMethod(WEB_APPLICATION_CONTEXT_UTILS, true, WEB_APPLICATION_CONTEXT, "getWebApplicationContext", ServletContext.class);
    private static final Method GET_BEAN = SpringUtils.getMethod(WEB_APPLICATION_CONTEXT, false, Object.class, "getBean", String.class);

    @Nonnull
    public static <T> T getBeanFor(@Nonnull ServletContext servletContext, @Nonnull String beanName, @Nonnull Class<T> beanType) throws ServletException {
        T plainBean;
        Object applicationContext = SpringUtils.getApplicationContext(servletContext);
        try {
            plainBean = beanType.cast(GET_BEAN.invoke(applicationContext, beanName));
        }
        catch (Exception e) {
            Throwable target;
            Throwable throwable = target = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : null;
            if (target != null && target.getClass().getName().endsWith("NoSuchBeanDefinitionException")) {
                throw new ServletException("Could not find bean '" + beanName + "' at " + applicationContext + ".", target);
            }
            throw new ServletException("Could not retrieve bean '" + beanName + "' from " + applicationContext + ".", target != null ? target : e);
        }
        if (!beanType.isInstance(plainBean)) {
            throw new ServletException("Could bean '" + beanName + "' is of type " + plainBean.getClass().getName() + " not of expected " + beanType.getName() + ".");
        }
        return beanType.cast(plainBean);
    }

    public static boolean isSpringAvailable() {
        return GET_WEB_APPLICATION_CONTEXT != null && GET_BEAN != null;
    }

    public static void assertSpringAvailable() throws ServletException {
        if (!SpringUtils.isSpringAvailable()) {
            throw new ServletException("There is no spring available. Could not find a valid implementation in classpath.");
        }
    }

    @Nonnull
    public static Object getApplicationContext(@Nonnull ServletContext servletContext) throws ServletException {
        Object applicationContext;
        SpringUtils.assertSpringAvailable();
        try {
            applicationContext = GET_WEB_APPLICATION_CONTEXT.invoke(null, servletContext);
        }
        catch (Exception e) {
            Throwable target = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : null;
            throw new ServletException("Could not retrieve spring context from " + servletContext + ".", target != null ? target : e);
        }
        if (applicationContext == null) {
            throw new ServletException("Could not find a spring context.");
        }
        return applicationContext;
    }

    @Nullable
    private static Class<?> findClass(@Nonnull String name) {
        Class<?> result;
        try {
            result = Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException ignored) {
            result = null;
        }
        return result;
    }

    @Nullable
    private static Method getMethod(@Nullable Class<?> fromType, boolean expectedStatic, Class<?> returnType, @Nonnull String name, Class<?> ... parameterTypes) {
        Method method;
        if (fromType != null) {
            try {
                method = fromType.getMethod(name, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(SpringUtils.buildMessageFor(fromType, expectedStatic, returnType, name, parameterTypes), e);
            }
            int modifiers = method.getModifiers();
            if (expectedStatic && !Modifier.isStatic(modifiers) || !expectedStatic && Modifier.isStatic(modifiers) || !returnType.isAssignableFrom(method.getReturnType())) {
                throw new RuntimeException(SpringUtils.buildMessageFor(fromType, expectedStatic, returnType, name, parameterTypes));
            }
        } else {
            method = null;
        }
        return method;
    }

    @Nonnull
    private static String buildMessageFor(@Nonnull Class<?> fromType, boolean expectedStatic, @Nonnull Class<?> returnType, @Nonnull String name, @Nullable Class<?>[] parameterTypes) {
        return "Could not find method " + (expectedStatic ? "static " : " ") + returnType.getName() + " public " + fromType.getName() + "." + name + "(" + StringUtils.join((Object[])parameterTypes) + ").";
    }

    private SpringUtils() {
    }
}

