/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jemoni.carbon;

import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.echocat.jemoni.carbon.MeasurePoint;
import org.echocat.jomon.runtime.concurrent.RetryForSpecifiedCountStrategy;
import org.echocat.jomon.runtime.concurrent.Retryer;
import org.echocat.jomon.runtime.concurrent.ThreadUtils;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.jomon.runtime.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarbonWriter
implements AutoCloseable {
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    public static final Duration DEFAULT_MAX_BUFFER_LIFETIME = new Duration("10s");
    private static final Logger LOG = LoggerFactory.getLogger(CarbonWriter.class);
    protected static final int BUFFER_SIZE = 1024;
    protected static final RetryForSpecifiedCountStrategy<Void> RETRYING_STRATEGY = new RetryForSpecifiedCountStrategy<Void>(2){

        protected boolean isExceptionThatForceRetry(@Nonnull Throwable e) {
            return e instanceof IOException;
        }
    };
    private final BlockingDeque<MeasurePoint> _messageQueue = new LinkedBlockingDeque<MeasurePoint>(1000);
    private List<ByteBuffer> _bufferQueue = new ArrayList<ByteBuffer>();
    private ByteBuffer _buffer = ByteBuffer.allocate(1024);
    private final Lock _lock = new ReentrantLock();
    private final Condition _condition = this._lock.newCondition();
    private volatile InetSocketAddress _address;
    private volatile Charset _charset = DEFAULT_CHARSET;
    private volatile Duration _maxBufferLifetime = DEFAULT_MAX_BUFFER_LIFETIME;
    private Thread _convertingThread;
    private Thread _writingThread;
    private Socket _socket;

    public InetSocketAddress getAddress() {
        return this._address;
    }

    public void setAddress(InetSocketAddress address) {
        block8: {
            this._address = address;
            this._lock.lock();
            try {
                if (this._writingThread != null) {
                    this._writingThread.setName(this.toString() + ".Writer");
                }
                if (this._convertingThread != null) {
                    this._convertingThread.setName(this.toString() + ".Converter");
                }
                if (this._socket == null) break block8;
                try {
                    ResourceUtils.closeQuietly((AutoCloseable)this._socket);
                }
                finally {
                    this._socket = null;
                }
            }
            finally {
                this._lock.unlock();
            }
        }
    }

    @Nonnull
    public Duration getMaxBufferLifetime() {
        return this._maxBufferLifetime;
    }

    public void setMaxBufferLifetime(@Nonnull Duration maxBufferLifetime) {
        this._maxBufferLifetime = maxBufferLifetime;
    }

    @Nonnull
    public Charset getCharset() {
        return this._charset;
    }

    public void setCharset(@Nonnull Charset charset) {
        this._charset = charset;
    }

    public void write(MeasurePoint ... measurePoints) throws InterruptedException {
        this.write(Arrays.asList(measurePoints));
    }

    public void write(@Nonnull Iterable<MeasurePoint> measurePoints) throws InterruptedException {
        for (MeasurePoint measurePoint : measurePoints) {
            this.write(measurePoint);
        }
    }

    @Nonnull
    public MeasurePoint write(@Nonnull String path, @Nonnull Number value) throws InterruptedException {
        MeasurePoint point = new MeasurePoint(path, value);
        this.write(point);
        return point;
    }

    @Nonnull
    public MeasurePoint write(@Nonnull String path, @Nonnull Date timestamp, @Nonnull Number value) throws InterruptedException {
        MeasurePoint point = new MeasurePoint(path, timestamp, value);
        this.write(point);
        return point;
    }

    public void write(@Nonnull MeasurePoint measurePoint) throws InterruptedException {
        if (this._writingThread != null || this._convertingThread != null) {
            this._messageQueue.put(measurePoint);
        }
    }

    @PostConstruct
    public void init() throws Exception {
        this._lock.lock();
        try {
            boolean success = false;
            try {
                this._writingThread = new Thread((Runnable)new Writer(), this.toString() + ".Writer");
                this._writingThread.setDaemon(true);
                this._writingThread.start();
                this._convertingThread = new Thread((Runnable)new Converter(), this.toString() + ".Converter");
                this._convertingThread.setDaemon(true);
                this._convertingThread.start();
                success = true;
            }
            finally {
                if (!success) {
                    this.close();
                }
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreDestroy
    public void close() throws Exception {
        try {
            ThreadUtils.stop((Thread)this._convertingThread);
            ThreadUtils.stop((Thread)this._writingThread);
        }
        finally {
            this._lock.lock();
            try {
                try {
                    try {
                        try {
                            ThreadUtils.stop((Thread)this._convertingThread);
                        }
                        finally {
                            this._convertingThread = null;
                        }
                    }
                    finally {
                        try {
                            ThreadUtils.stop((Thread)this._writingThread);
                        }
                        finally {
                            this._writingThread = null;
                        }
                    }
                }
                finally {
                    try {
                        ResourceUtils.closeQuietly((AutoCloseable)this._socket);
                    }
                    finally {
                        this._socket = null;
                    }
                }
            }
            finally {
                this._lock.unlock();
            }
        }
    }

    protected void convertAndPutIntoQueue(@Nonnull MeasurePoint measurePoint) {
        byte[] message = this.convert(measurePoint);
        this._lock.lock();
        try {
            if (message.length > this._buffer.remaining()) {
                if (this._bufferQueue.size() > 1000) {
                    LOG.warn("The queue seems to be full. Current size is " + this._bufferQueue.size() + ". Is the converting thread dead?");
                }
                this._bufferQueue.add(this._buffer);
                this._buffer = ByteBuffer.allocate(message.length < 1024 ? 1024 : message.length);
            }
            this._buffer.put(message);
            this._condition.signalAll();
        }
        finally {
            this._lock.unlock();
        }
    }

    @Nonnull
    protected byte[] convert(@Nonnull MeasurePoint measurePoint) {
        String messageAsString = this.formatPath(measurePoint) + " " + this.formatValue(measurePoint) + " " + this.toUnixTimestamp(measurePoint) + "\n";
        return messageAsString.getBytes(this._charset);
    }

    @Nonnull
    protected String formatPath(@Nonnull MeasurePoint measurePoint) {
        StringBuilder sb = new StringBuilder();
        for (char c : measurePoint.getPath().toCharArray()) {
            if (Character.isLetterOrDigit(c) || c == '-' || c == '_' || c == '.') {
                sb.append(c);
                continue;
            }
            if (!Character.isWhitespace(c)) continue;
            sb.append('_');
        }
        return sb.toString();
    }

    @Nonnull
    protected Number formatValue(@Nonnull MeasurePoint measurePoint) {
        return measurePoint.getValue();
    }

    @Nonnegative
    protected long toUnixTimestamp(@Nonnull MeasurePoint measurePoint) {
        return TimeUnit.MILLISECONDS.toSeconds(measurePoint.getTimestamp().getTime());
    }

    @Nonnull
    protected List<ByteBuffer> getNextForWrite(boolean force) throws InterruptedException {
        ArrayList<ByteBuffer> result = new ArrayList<ByteBuffer>();
        if (force) {
            this._lock.lock();
        } else {
            this._lock.lockInterruptibly();
        }
        try {
            if (force || !this._condition.await(this._maxBufferLifetime.toMilliSeconds(), TimeUnit.MILLISECONDS)) {
                result.add(this._buffer);
                this._buffer = ByteBuffer.allocate(1024);
            }
            result.addAll(this._bufferQueue);
            this._bufferQueue = new ArrayList<ByteBuffer>();
        }
        finally {
            this._lock.unlock();
        }
        return result;
    }

    public void flush() throws IOException {
        try {
            List<ByteBuffer> buffers = this.getNextForWrite(true);
            this.writeMessages(buffers);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Could not flush.", e);
        }
    }

    protected void writeMessages(@Nonnull Iterable<ByteBuffer> buffers) throws InterruptedException, IOException {
        for (final ByteBuffer buffer : buffers) {
            Retryer.executeWithRetry((Callable)new Callable<Void>(){

                @Override
                public Void call() throws IOException, InterruptedException {
                    CarbonWriter.this.writeMessage(buffer);
                    return null;
                }
            }, RETRYING_STRATEGY, IOException.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeMessage(@Nonnull ByteBuffer buffer) throws IOException, InterruptedException {
        boolean success = false;
        Socket socket = this.getSocket();
        if (socket != null) {
            try {
                OutputStream os = socket.getOutputStream();
                try {
                    os.write(buffer.array(), 0, buffer.position());
                    success = true;
                }
                finally {
                    if (success) {
                        os.flush();
                    } else {
                        ResourceUtils.closeQuietly((AutoCloseable)os);
                    }
                }
            }
            finally {
                if (!success) {
                    ResourceUtils.closeQuietly((AutoCloseable)socket);
                }
            }
        }
    }

    @Nullable
    protected Socket getSocket() throws IOException, InterruptedException {
        this._lock.lockInterruptibly();
        try {
            if (this._socket == null || !this._socket.isConnected() || this._socket.isClosed()) {
                InetSocketAddress address = this._address;
                if (address != null) {
                    this._socket = new Socket();
                    this._socket.connect(address);
                } else {
                    this._socket = null;
                }
            }
            Socket socket = this._socket;
            return socket;
        }
        finally {
            this._lock.unlock();
        }
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            result = true;
        } else if (!(o instanceof CarbonWriter)) {
            result = false;
        } else {
            CarbonWriter that = (CarbonWriter)o;
            result = this._address != null ? this._address.equals(that._address) : that._address == null;
        }
        return result;
    }

    public int hashCode() {
        return this._address != null ? this._address.hashCode() : 0;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this._address + "}";
    }

    protected class Writer
    implements Runnable {
        protected Writer() {
        }

        @Override
        public void run() {
            block8: while (true) {
                try {
                    while (!Thread.currentThread().isInterrupted()) {
                        List<ByteBuffer> buffers = CarbonWriter.this.getNextForWrite(false);
                        try {
                            CarbonWriter.this.writeMessages(buffers);
                            continue block8;
                        }
                        catch (ConnectException e) {
                            CarbonWriter.this._lock.lockInterruptibly();
                            try {
                                if (CarbonWriter.this._bufferQueue.size() < 100000) {
                                    LOG.warn("Could not reach " + CarbonWriter.this._address + " reschedule messages.", (Throwable)e);
                                    CarbonWriter.this._bufferQueue.addAll(buffers);
                                    continue;
                                }
                                LOG.warn("Could not reach " + CarbonWriter.this._address + " . The messages are lost.", (Throwable)e);
                            }
                            finally {
                                CarbonWriter.this._lock.unlock();
                            }
                        }
                        catch (IOException e) {
                            LOG.warn("Could not write message to " + CarbonWriter.this._address + ". The messages are lost.", (Throwable)e);
                        }
                    }
                    break;
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
    }

    protected class Converter
    implements Runnable {
        protected Converter() {
        }

        @Override
        public void run() {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    MeasurePoint next = (MeasurePoint)CarbonWriter.this._messageQueue.take();
                    CarbonWriter.this.convertAndPutIntoQueue(next);
                }
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

