/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jemoni.carbon;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Nonnull;

public class MeasurePoint {
    private static final String TIME_PATTERN = "HH:mm:ss";
    private final String _path;
    private final Date _timestamp;
    private final Number _value;

    public MeasurePoint(@Nonnull String path, @Nonnull Number value) {
        this(path, new Date(System.currentTimeMillis() / 1000L * 1000L), value);
    }

    public MeasurePoint(@Nonnull String path, @Nonnull Date timestamp, @Nonnull Number value) {
        this._path = path;
        this._timestamp = timestamp;
        this._value = value;
    }

    @Nonnull
    public String getPath() {
        return this._path;
    }

    @Nonnull
    public Date getTimestamp() {
        return this._timestamp;
    }

    @Nonnull
    public Number getValue() {
        return this._value;
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            result = true;
        } else if (!(o instanceof MeasurePoint)) {
            result = false;
        } else {
            MeasurePoint that = (MeasurePoint)o;
            result = this.getPath().equals(that.getPath()) && this.getTimestamp().equals(that.getTimestamp()) && this.getValue().equals(that.getValue());
        }
        return result;
    }

    public int hashCode() {
        int result = this.getPath().hashCode();
        result = 31 * result + this.getTimestamp().hashCode();
        result = 31 * result + this.getValue().hashCode();
        return result;
    }

    public String toString() {
        return this.getPath() + "(" + new SimpleDateFormat(TIME_PATTERN).format(this.getTimestamp()) + "): " + this.getValue();
    }
}

