/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jemoni.carbon.jmx;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.InvalidKeyException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.relation.MBeanServerNotificationFilter;
import org.apache.commons.lang3.StringUtils;
import org.echocat.jemoni.carbon.CarbonWriter;
import org.echocat.jemoni.carbon.jmx.AttributeDefinition;
import org.echocat.jemoni.carbon.jmx.AttributeDefinitions;
import org.echocat.jemoni.carbon.jmx.configuration.Configuration;
import org.echocat.jemoni.carbon.jmx.configuration.Rule;
import org.echocat.jemoni.jmx.JmxRegistry;
import org.echocat.jomon.runtime.concurrent.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jmx2CarbonBridge
implements AutoCloseable {
    private static final Pattern NAME_REPLACE_PATTERN = Pattern.compile("[,:][^=]+\\=");
    private static final Logger LOG = LoggerFactory.getLogger(Jmx2CarbonBridge.class);
    protected static final MBeanServer SERVER = ManagementFactory.getPlatformMBeanServer();
    private final NotificationListener _mbeanIndexChangeListener = new NotificationListener(){

        @Override
        public void handleNotification(Notification notification, Object handback) {
            MBeanServerNotification mbs = (MBeanServerNotification)notification;
            if ("JMX.mbean.registered".equals(mbs.getType()) || "JMX.mbean.unregistered".equals(mbs.getType())) {
                try {
                    Jmx2CarbonBridge.this.updateMBeanIndex();
                }
                catch (Exception e) {
                    LOG.warn("Could not update index.", (Throwable)e);
                }
            }
        }
    };
    private final MBeanServerNotificationFilter _notificationFilter = new MBeanServerNotificationFilter();
    private final MBeanServer _server;
    private final CarbonWriter _carbonWriter;
    private final Set<Thread> _updatingThreads = new HashSet<Thread>();
    private ClassLoader _classLoader = Thread.currentThread().getContextClassLoader();
    private Configuration _configuration;
    private String _pathPrefix = Jmx2CarbonBridge.getLocalhost() + ".";

    @Nonnull
    protected static String getLocalhost() {
        String result = "localhost";
        try {
            result = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        ArrayList<String> hostParts = new ArrayList<String>(Arrays.asList(result.split("\\.")));
        Collections.reverse(hostParts);
        return StringUtils.join(hostParts, (String)".");
    }

    public Jmx2CarbonBridge(@Nonnull CarbonWriter carbonWriter) {
        this(SERVER, carbonWriter);
    }

    public Jmx2CarbonBridge(@Nonnull JmxRegistry jmxRegistry, @Nonnull CarbonWriter carbonWriter) {
        this(jmxRegistry.getServer(), carbonWriter);
    }

    public Jmx2CarbonBridge(@Nonnull MBeanServer server, @Nonnull CarbonWriter carbonWriter) {
        this._server = server;
        this._carbonWriter = carbonWriter;
        this._notificationFilter.enableAllObjectNames();
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    public Configuration getConfiguration() {
        return this._configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this._configuration = configuration;
    }

    public String getPathPrefix() {
        return this._pathPrefix;
    }

    public void setPathPrefix(String pathPrefix) {
        this._pathPrefix = pathPrefix;
    }

    @Nonnull
    public CarbonWriter getCarbonWriter() {
        return this._carbonWriter;
    }

    @PostConstruct
    public void init() throws Exception {
        this._server.addNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this._mbeanIndexChangeListener, (NotificationFilter)this._notificationFilter, null);
        this.updateMBeanIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMBeanIndex() throws Exception {
        Configuration configuration = this._configuration;
        Jmx2CarbonBridge jmx2CarbonBridge = this;
        synchronized (jmx2CarbonBridge) {
            HashMap<Rule, Set<AttributeDefinitions>> ruleToAttributeNames = new HashMap<Rule, Set<AttributeDefinitions>>();
            if (configuration != null && configuration.hasItems()) {
                Set<ObjectName> objectNames = this._server.queryNames(null, null);
                for (ObjectName objectName : objectNames) {
                    try {
                        MBeanInfo mBeanInfo = this._server.getMBeanInfo(objectName);
                        MBeanAttributeInfo[] attributes = mBeanInfo.getAttributes();
                        for (Rule rule : configuration) {
                            HashSet<AttributeDefinition> singleAttributeDefinitions = new HashSet<AttributeDefinition>();
                            for (MBeanAttributeInfo attribute : attributes) {
                                AttributeDefinition attributeDefinition = this.findDefinitionFor(objectName, attribute);
                                if (!rule.apply(attributeDefinition)) continue;
                                singleAttributeDefinitions.add(attributeDefinition);
                            }
                            if (singleAttributeDefinitions.isEmpty()) continue;
                            HashSet<AttributeDefinitions> attributeNames = (HashSet<AttributeDefinitions>)ruleToAttributeNames.get(rule);
                            if (attributeNames == null) {
                                attributeNames = new HashSet<AttributeDefinitions>();
                                ruleToAttributeNames.put(rule, attributeNames);
                            }
                            attributeNames.add(new AttributeDefinitions(objectName, singleAttributeDefinitions));
                        }
                    }
                    catch (InstanceNotFoundException instanceNotFoundException) {
                    }
                }
            }
            this.startThreads(configuration, ruleToAttributeNames);
        }
    }

    @Nullable
    protected AttributeDefinition findDefinitionFor(@Nonnull ObjectName objectName, @Nonnull MBeanAttributeInfo info) {
        Descriptor descriptor = info.getDescriptor();
        OpenType openType = (OpenType)descriptor.getFieldValue("openType");
        return this.findDefinitionFor(objectName, info, info.getName(), openType);
    }

    @Nullable
    protected AttributeDefinition findDefinitionFor(@Nonnull ObjectName objectName, @Nonnull MBeanAttributeInfo info, @Nonnull String name, @Nullable OpenType<?> openType) {
        Class<?> type;
        String typeName;
        AttributeDefinition result = openType instanceof SimpleType ? this.findDefinitionFor(objectName, name, (SimpleType)openType) : (openType instanceof CompositeType ? this.findDefinitionFor(objectName, info, name, (CompositeType)openType) : ((typeName = info.getType()) != null && typeName.startsWith("java.") ? ((type = this.tryLoadClassBy(typeName)) != null && (Number.class.isAssignableFrom(type) || Boolean.class.equals(type) || Character.class.equals(type)) ? new AttributeDefinition(objectName, name, type) : null) : null));
        return result;
    }

    @Nullable
    protected AttributeDefinition findDefinitionFor(@Nonnull ObjectName objectName, @Nonnull String name, @Nonnull SimpleType<?> simpleType) {
        Class<?> type = this.tryLoadClassFor(simpleType);
        AttributeDefinition result = type != null && Number.class.isAssignableFrom(type) ? new AttributeDefinition(objectName, name, type) : null;
        return result;
    }

    @Nullable
    protected AttributeDefinition findDefinitionFor(@Nonnull ObjectName objectName, @Nonnull MBeanAttributeInfo info, @Nonnull String name, @Nonnull CompositeType compositeType) {
        HashSet<AttributeDefinition> children = new HashSet<AttributeDefinition>();
        for (String key : compositeType.keySet()) {
            OpenType<?> childType;
            AttributeDefinition child = this.findDefinitionFor(objectName, info, key, childType = compositeType.getType(key));
            if (child == null) continue;
            children.add(child);
        }
        return children.isEmpty() ? null : new AttributeDefinition(objectName, name, CompositeData.class, children);
    }

    @Nullable
    protected Class<?> tryLoadClassFor(@Nullable SimpleType<?> simpleType) {
        return this.tryLoadClassBy(simpleType != null ? simpleType.getClassName() : null);
    }

    @Nullable
    protected Class<?> tryLoadClassBy(@Nullable String className) {
        Class<?> result;
        if (className == null) {
            result = null;
        } else {
            try {
                result = this._classLoader.loadClass(className);
            }
            catch (ClassNotFoundException ignored) {
                result = null;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startThreads(@Nonnull Configuration configuration, @Nonnull Map<Rule, Set<AttributeDefinitions>> ruleToAttributeNames) {
        Jmx2CarbonBridge jmx2CarbonBridge = this;
        synchronized (jmx2CarbonBridge) {
            this.stopThreads();
            for (Map.Entry<Rule, Set<AttributeDefinitions>> ruleAndAttributeNames : ruleToAttributeNames.entrySet()) {
                Rule rule = ruleAndAttributeNames.getKey();
                Worker worker = new Worker(configuration, rule, ruleAndAttributeNames.getValue());
                Thread thread = new Thread((Runnable)worker, worker.toString());
                thread.start();
                this._updatingThreads.add(thread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopThreads() {
        Jmx2CarbonBridge jmx2CarbonBridge = this;
        synchronized (jmx2CarbonBridge) {
            Iterator<Thread> i = this._updatingThreads.iterator();
            while (i.hasNext()) {
                Thread thread = i.next();
                ThreadUtils.stop((Thread)thread);
                i.remove();
            }
        }
    }

    protected void stopThread(@Nullable Thread thread) {
        if (thread != null) {
            thread.interrupt();
            try {
                long tries = 0L;
                while (thread.isAlive()) {
                    thread.join(50L);
                    thread.interrupt();
                    if (!thread.isAlive() || ++tries % 200L != 0L) continue;
                    LOG.info("Still wait for termination of '" + thread + "'...");
                }
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
                LOG.debug("Could not wait for termination of '" + thread + "' - but this thread was interrupted.");
            }
        }
    }

    @Override
    @PreDestroy
    public void close() throws Exception {
        try {
            this._server.removeNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this._mbeanIndexChangeListener, (NotificationFilter)this._notificationFilter, null);
        }
        finally {
            this.stopThreads();
        }
    }

    protected class Worker
    implements Runnable {
        private final Configuration _configuration;
        private final Rule _rule;
        private final Set<AttributeDefinitions> _attributeNames;

        public Worker(@Nonnull Configuration configuration, @Nonnull Rule rule, Set<AttributeDefinitions> attributeNames) {
            this._configuration = configuration;
            this._rule = rule;
            this._attributeNames = attributeNames;
        }

        @Override
        public void run() {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    if (Jmx2CarbonBridge.this._carbonWriter.getAddress() != null) {
                        for (AttributeDefinitions attributeDefinitions : this._attributeNames) {
                            ObjectName objectName = attributeDefinitions.getObjectName();
                            Iterator<AttributeDefinition> i = attributeDefinitions.iterator();
                            while (i.hasNext()) {
                                AttributeDefinition definition = i.next();
                                try {
                                    Map<String, Object> keyToValue = this.findValuesOf(definition);
                                    for (Map.Entry<String, Object> keyAndValue : keyToValue.entrySet()) {
                                        String key = keyAndValue.getKey();
                                        Object value = keyAndValue.getValue();
                                        if (!(value instanceof Number)) continue;
                                        Jmx2CarbonBridge.this._carbonWriter.write(this.getPathFor(objectName, key, definition), (Number)value);
                                    }
                                }
                                catch (InstanceNotFoundException ignored) {
                                    i.remove();
                                }
                                catch (Exception e) {
                                    if (!(e instanceof RuntimeMBeanException) || !(e.getCause() instanceof UnsupportedOperationException)) {
                                        LOG.warn("Could not read value of " + objectName + "->" + definition + ". This attribute will ignored from now.", (Throwable)e);
                                    }
                                    i.remove();
                                }
                            }
                        }
                    }
                    this._rule.getUpdateEvery().sleep();
                }
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }

        @Nonnull
        protected String getPathFor(@Nonnull ObjectName objectName, @Nonnull String key, @Nonnull AttributeDefinition definition) {
            StringBuilder sb = new StringBuilder();
            String pathPrefix = Jmx2CarbonBridge.this._pathPrefix;
            if (pathPrefix != null) {
                sb.append(pathPrefix);
            }
            sb.append(this.getNormalizedNameFor(objectName)).append('.').append(key);
            return this._configuration.format(definition, sb.toString());
        }

        @Nonnull
        protected String getNormalizedNameFor(@Nonnull ObjectName objectName) {
            String nameWithoutDots = objectName.toString().replace('.', '_');
            return NAME_REPLACE_PATTERN.matcher(nameWithoutDots).replaceAll(".");
        }

        @Nonnull
        protected Map<String, Object> findValuesOf(@Nonnull AttributeDefinition definition) throws Exception {
            return this.findValuesOf(definition, null, null);
        }

        @Nonnull
        protected Map<String, Object> findValuesOf(@Nonnull AttributeDefinition definition, @Nullable String namePrefix, @Nullable Object parent) throws Exception {
            HashMap<String, Object> nameToValue = new HashMap<String, Object>();
            Object value = this.findValueOf(definition, parent);
            if (value instanceof CompositeData) {
                Set<AttributeDefinition> children = definition.getChildren();
                if (children != null) {
                    String newNamePrefix = this.getNameFor(definition, namePrefix);
                    for (AttributeDefinition child : children) {
                        nameToValue.putAll(this.findValuesOf(child, newNamePrefix, value));
                    }
                }
            } else if (value instanceof Number) {
                nameToValue.put(this.getNameFor(definition, namePrefix), value);
            } else if (value instanceof Character) {
                nameToValue.put(this.getNameFor(definition, namePrefix), ((Character)value).charValue());
            } else if (value instanceof Boolean) {
                nameToValue.put(this.getNameFor(definition, namePrefix), Boolean.TRUE.equals(value) ? 1 : 0);
            }
            return nameToValue;
        }

        @Nullable
        protected Object findValueOf(@Nonnull AttributeDefinition definition, @Nullable Object parent) throws Exception {
            Object result;
            block6: {
                try {
                    if (parent == null) {
                        result = Jmx2CarbonBridge.this._server.getAttribute(definition.getObjectName(), definition.getName());
                        break block6;
                    }
                    if (parent instanceof CompositeData) {
                        CompositeData compositeData = (CompositeData)parent;
                        try {
                            result = compositeData.get(definition.getName());
                        }
                        catch (InvalidKeyException ignored) {
                            result = null;
                        }
                        break block6;
                    }
                    throw new UnsupportedOperationException();
                }
                catch (AttributeNotFoundException ignored) {
                    result = null;
                }
            }
            return result != null && definition.getValueType().isInstance(result) ? result : null;
        }

        @Nullable
        protected String getNameFor(@Nonnull AttributeDefinition definition, @Nullable String namePrefix) {
            StringBuilder sb = new StringBuilder();
            if (namePrefix != null) {
                sb.append(namePrefix).append('.');
            }
            sb.append(definition.getName());
            return sb.toString();
        }

        public String toString() {
            return Jmx2CarbonBridge.this.getClass().getSimpleName() + "." + this.getClass().getSimpleName() + "{" + this._rule.getName() + "}";
        }
    }
}

