/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jemoni.carbon.jmx.configuration;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jemoni.carbon.jmx.AttributeDefinition;
import org.echocat.jemoni.carbon.jmx.configuration.ObjectRule;

public abstract class IncludeExcludeSupport<T extends IncludeExcludeSupport<T>> {
    private List<ObjectRule> _includes;
    private List<ObjectRule> _excludes;

    public List<ObjectRule> getIncludes() {
        return this._includes;
    }

    public void setIncludes(List<ObjectRule> includes) {
        this._includes = includes;
    }

    public List<ObjectRule> getExcludes() {
        return this._excludes;
    }

    public void setExcludes(List<ObjectRule> excludes) {
        this._excludes = excludes;
    }

    public boolean apply(@Nullable AttributeDefinition input) {
        Boolean excludeMatch;
        Boolean includeMatch;
        boolean result = input != null ? ((includeMatch = this.apply(input, this._includes)) == null || includeMatch.booleanValue() ? (excludeMatch = this.apply(input, this._excludes)) == null || excludeMatch == false : false) : false;
        return result;
    }

    @Nullable
    protected Boolean apply(@Nonnull AttributeDefinition attributeDefinition, @Nullable List<ObjectRule> rules) {
        Boolean result;
        if (rules == null || rules.isEmpty()) {
            result = null;
        } else {
            result = null;
            for (ObjectRule rule : rules) {
                Boolean ruleMatch = rule.apply(attributeDefinition);
                if (ruleMatch == null) continue;
                result = ruleMatch;
                if (!ruleMatch.booleanValue()) continue;
                break;
            }
        }
        return result;
    }

    @Nonnull
    public T includes(@Nullable List<ObjectRule> includes) {
        this.setIncludes(includes);
        return this.thisInstance();
    }

    @Nonnull
    public T includes(ObjectRule ... includes) {
        return this.includes(includes != null ? Arrays.asList(includes) : null);
    }

    @Nonnull
    public T excludes(@Nullable List<ObjectRule> excludes) {
        this.setExcludes(excludes);
        return this.thisInstance();
    }

    @Nonnull
    public T excludes(ObjectRule ... excludes) {
        return this.excludes(excludes != null ? Arrays.asList(excludes) : null);
    }

    @Nonnull
    protected T thisInstance() {
        return (T)this;
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            result = true;
        } else if (!(o instanceof IncludeExcludeSupport)) {
            result = false;
        } else {
            IncludeExcludeSupport that = (IncludeExcludeSupport)o;
            result = (this._includes != null ? this._includes.equals(that._includes) : that._includes == null) && (this._excludes != null ? this._excludes.equals(that._excludes) : that._excludes == null);
        }
        return result;
    }

    public int hashCode() {
        int result = this._includes != null ? this._includes.hashCode() : 0;
        result = 31 * result + (this._excludes != null ? this._excludes.hashCode() : 0);
        return result;
    }
}

