/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jemoni.carbon;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jemoni.carbon.MeasurePoint;
import org.echocat.jomon.net.FreeTcpPortDetector;
import org.echocat.jomon.runtime.concurrent.ThreadUtils;
import org.echocat.jomon.runtime.numbers.IntegerRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualCarbonServer
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(VirtualCarbonServer.class);
    private final List<MeasurePoint> _recordedMeasurePoints = new ArrayList<MeasurePoint>();
    private final InetSocketAddress _address;
    private final Acceptor _acceptor;
    private final Set<Worker> _workers = new HashSet<Worker>();
    private Exception _fatalException;
    private volatile Charset _charset = Charset.forName("UTF-8");

    public VirtualCarbonServer(@Nonnull InetSocketAddress address) {
        ServerSocket serverSocket;
        try {
            this._address = address.getAddress().isAnyLocalAddress() ? new InetSocketAddress(InetAddress.getLocalHost(), address.getPort()) : address;
            serverSocket = new ServerSocket();
            serverSocket.bind(address);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not bind to " + address + ".", e);
        }
        this._acceptor = new Acceptor(serverSocket);
        this._acceptor.start();
    }

    public VirtualCarbonServer(@Nonnegative int port) {
        this(new InetSocketAddress((InetAddress)null, port));
    }

    public VirtualCarbonServer(@Nullable InetAddress address, @Nullable IntegerRange portRange) {
        this(VirtualCarbonServer.detectPort(address, portRange));
    }

    public VirtualCarbonServer(@Nullable InetAddress address) {
        this(address, null);
    }

    public VirtualCarbonServer(@Nullable IntegerRange portRange) {
        this(null, portRange);
    }

    public VirtualCarbonServer() {
        this((IntegerRange)null);
    }

    @Nonnull
    public Charset getCharset() {
        return this._charset;
    }

    public void setCharset(@Nonnull Charset charset) {
        this._charset = charset;
    }

    @Nonnull
    public InetSocketAddress getAddress() {
        return this._address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public List<MeasurePoint> getLastRecordedMeasurePoints() throws IOException {
        VirtualCarbonServer virtualCarbonServer = this;
        synchronized (virtualCarbonServer) {
            this.assertNoFatalException();
            return new ArrayList<MeasurePoint>(this._recordedMeasurePoints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRecordedMeasurePoints() throws IOException {
        VirtualCarbonServer virtualCarbonServer = this;
        synchronized (virtualCarbonServer) {
            this.assertNoFatalException();
            this._recordedMeasurePoints.clear();
        }
    }

    protected void assertNoFatalException() throws IOException {
        if (this._fatalException != null) {
            if (this._fatalException instanceof RuntimeException) {
                throw (RuntimeException)this._fatalException;
            }
            if (this._fatalException instanceof IOException) {
                throw (IOException)this._fatalException;
            }
            throw new RuntimeException("Could not read messages from remote.", this._fatalException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recordedMeasurePoints(@Nullable MeasurePoint measurePoint) {
        if (measurePoint != null) {
            VirtualCarbonServer virtualCarbonServer = this;
            synchronized (virtualCarbonServer) {
                this._recordedMeasurePoints.add(measurePoint);
            }
        }
    }

    @Nullable
    protected MeasurePoint parseMeasurePoint(@Nonnull String plain, @Nonnull SocketAddress remote) {
        MeasurePoint measurePoint;
        String trimmed = plain.trim();
        if (!trimmed.isEmpty()) {
            String[] parts = trimmed.split(" ", 3);
            if (parts.length == 3) {
                try {
                    Date date = new Date(TimeUnit.SECONDS.toMillis(Long.parseLong(parts[2])));
                    double value = Double.parseDouble(parts[1]);
                    measurePoint = new MeasurePoint(parts[0], date, value);
                }
                catch (NumberFormatException ignored) {
                    LOG.info("Received illegal measure point from " + remote + ": " + trimmed);
                    measurePoint = null;
                }
            } else {
                LOG.info("Received illegal measure point from " + remote + ": " + trimmed);
                measurePoint = null;
            }
        } else {
            measurePoint = null;
        }
        return measurePoint;
    }

    @Override
    public void close() throws IOException {
        ThreadUtils.stop(this._workers);
        ThreadUtils.stop((Thread)this._acceptor);
    }

    @Nonnull
    protected static InetSocketAddress detectPort(@Nullable InetAddress address, @Nullable IntegerRange portRange) {
        int port = new FreeTcpPortDetector(address, portRange).detect();
        return new InetSocketAddress(address, port);
    }

    protected class Worker
    extends Thread
    implements Closeable {
        private final Socket _socket;

        public Worker(Socket socket) {
            super(VirtualCarbonServer.this.getClass().getSimpleName() + ".Worker(" + socket.getRemoteSocketAddress() + ">" + socket.getLocalSocketAddress() + ")");
            this._socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try (InputStream is = this._socket.getInputStream();
                 InputStreamReader reader = new InputStreamReader(is, VirtualCarbonServer.this._charset);
                 BufferedReader bufferedReader = new BufferedReader(reader);){
                String line = bufferedReader.readLine();
                while (!Worker.currentThread().isInterrupted() && this._socket.isConnected() && line != null) {
                    MeasurePoint measurePoint = VirtualCarbonServer.this.parseMeasurePoint(line, this._socket.getRemoteSocketAddress());
                    VirtualCarbonServer.this.recordedMeasurePoints(measurePoint);
                    line = bufferedReader.readLine();
                }
            }
            catch (InterruptedIOException ignored) {
                Worker.currentThread().interrupt();
            }
            catch (SocketException ignored) {
            }
            catch (Exception e) {
                VirtualCarbonServer virtualCarbonServer = VirtualCarbonServer.this;
                synchronized (virtualCarbonServer) {
                    VirtualCarbonServer.this._fatalException = e;
                }
                LOG.error("Got an error from " + this._socket + " while handle connection.", (Throwable)e);
            }
        }

        @Override
        public void close() throws IOException {
            this._socket.close();
            this.interrupt();
        }
    }

    protected class Acceptor
    extends Thread
    implements Closeable {
        private final ServerSocket _serverSocket;

        public Acceptor(ServerSocket serverSocket) {
            super(VirtualCarbonServer.this.getClass().getSimpleName() + ".Acceptor(" + serverSocket.getLocalSocketAddress() + ")");
            this._serverSocket = serverSocket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!Acceptor.currentThread().isInterrupted()) {
                    Socket remote = this._serverSocket.accept();
                    Set set = VirtualCarbonServer.this._workers;
                    synchronized (set) {
                        Worker worker = new Worker(remote);
                        VirtualCarbonServer.this._workers.add(worker);
                        worker.start();
                    }
                }
                return;
            }
            catch (InterruptedIOException ignored) {
                Acceptor.currentThread().interrupt();
                return;
            }
            catch (Exception e) {
                if (e instanceof SocketException) {
                    if (this._serverSocket.isClosed()) return;
                }
                VirtualCarbonServer virtualCarbonServer = VirtualCarbonServer.this;
                synchronized (virtualCarbonServer) {
                    VirtualCarbonServer.this._fatalException = e;
                }
                LOG.error("Got an error from " + this._serverSocket + " while accepting a connection.", (Throwable)e);
            }
        }

        @Override
        public void close() throws IOException {
            this._serverSocket.close();
            this.interrupt();
        }
    }
}

