/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jemoni.carbon.jmx;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.management.ObjectName;
import org.apache.commons.lang3.StringUtils;

public class AttributeDefinition {
    private final ObjectName _objectName;
    private final String _name;
    private final Class<?> _valueType;
    private final Set<AttributeDefinition> _children;

    public AttributeDefinition(@Nullable ObjectName objectName, @Nonnull String name, @Nonnull Class<?> valueType) {
        this(objectName, name, valueType, null);
    }

    public AttributeDefinition(@Nullable ObjectName objectName, @Nonnull String name, @Nonnull Class<?> valueType, @Nullable Set<AttributeDefinition> children) {
        this._objectName = objectName;
        this._name = name;
        this._valueType = valueType;
        this._children = children;
    }

    @Nonnull
    public ObjectName getObjectName() {
        return this._objectName;
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    @Nonnull
    public Class<?> getValueType() {
        return this._valueType;
    }

    @Nonnull
    public Set<AttributeDefinition> getChildren() {
        return this._children;
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            result = true;
        } else if (!(o instanceof AttributeDefinition)) {
            result = false;
        } else {
            AttributeDefinition that = (AttributeDefinition)o;
            result = (this._objectName != null ? this._objectName.equals(that._objectName) : this._objectName == null) && this._name.equals(that._name) && (this._children != null ? this._children.equals(that._children) : that._children == null);
        }
        return result;
    }

    public int hashCode() {
        int result = this._objectName != null ? this._objectName.hashCode() : 0;
        result = 31 * result + this._name.hashCode();
        result = 31 * result + (this._children != null ? this._children.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this._objectName != null) {
            sb.append(this._objectName).append("->");
        }
        sb.append(this._name).append('(').append(this._valueType.getName()).append(')');
        if (this._children != null && !this._children.isEmpty()) {
            sb.append('{').append(StringUtils.join(this._children, (char)',')).append('}');
        }
        return sb.toString();
    }
}

