/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jemoni.carbon.jmx.configuration;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.echocat.jemoni.carbon.jmx.AttributeDefinition;
import org.echocat.jemoni.carbon.jmx.configuration.Format;
import org.echocat.jemoni.carbon.jmx.configuration.Rule;

@XmlRootElement(name="configuration", namespace="https://jemoni.echocat.org/schemas/jmx2carbonRules.xsd")
@XmlType(name="configuration", namespace="https://jemoni.echocat.org/schemas/jmx2carbonRules.xsd", propOrder={"rules", "formats"})
public class Configuration
implements Iterable<Rule> {
    private List<Rule> _rules;
    private List<Format> _formats;

    @Nonnull
    public static Configuration configuration() {
        return new Configuration();
    }

    @XmlElement(name="rule", required=false, namespace="https://jemoni.echocat.org/schemas/jmx2carbonRules.xsd")
    public List<Rule> getRules() {
        return this._rules;
    }

    public void setRules(List<Rule> rules) {
        this._rules = rules;
    }

    @XmlElement(name="format", required=false, namespace="https://jemoni.echocat.org/schemas/jmx2carbonRules.xsd")
    public List<Format> getFormats() {
        return this._formats;
    }

    public void setFormats(List<Format> formats) {
        this._formats = formats;
    }

    @Override
    public Iterator<Rule> iterator() {
        return this._rules != null ? this._rules.iterator() : Collections.emptyIterator();
    }

    public boolean hasItems() {
        return this._rules != null && !this._rules.isEmpty();
    }

    @Nonnull
    public Configuration rules(@Nullable List<Rule> rules) {
        this.setRules(rules);
        return this;
    }

    @Nonnull
    public Configuration rules(Rule ... rules) {
        return this.rules(rules != null ? Arrays.asList(rules) : null);
    }

    @Nonnull
    public Configuration formats(@Nullable List<Format> formats) {
        this.setFormats(formats);
        return this;
    }

    @Nonnull
    public Configuration formats(Format ... formats) {
        return this.formats(formats != null ? Arrays.asList(formats) : null);
    }

    @Nonnull
    public String format(@Nonnull AttributeDefinition what, @Nonnull String propertyName) {
        List<Format> formats = this._formats;
        String out = propertyName;
        if (formats != null) {
            for (Format format : formats) {
                if (!format.apply(what)) continue;
                out = format.format(propertyName);
            }
        }
        return out;
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            result = true;
        } else if (o == null || o.getClass() != Configuration.class) {
            result = false;
        } else {
            Configuration that = (Configuration)o;
            result = this._rules != null ? this._rules.equals(that._rules) : that._rules == null;
        }
        return result;
    }

    public int hashCode() {
        return this._rules != null ? this._rules.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append('{');
        sb.append("rules=").append(this._rules);
        sb.append(", formats=").append(this._formats);
        sb.append('}');
        return sb.toString();
    }
}

