/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jemoni.carbon.jmx.configuration;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.echocat.jemoni.carbon.jmx.configuration.IncludeExcludeSupport;
import org.echocat.jemoni.carbon.jmx.configuration.ObjectRule;
import org.echocat.jomon.runtime.jaxb.PatternAdapter;

@XmlType(name="format", namespace="https://jemoni.echocat.org/schemas/jmx2carbonRules.xsd", propOrder={"includes", "excludes"})
public class Format
extends IncludeExcludeSupport<Format> {
    private Pattern _pattern;
    private String _replacement;

    @Nonnull
    public static Format format(@Nonnull Pattern pattern, @Nonnull String replacement) {
        return new Format().pattern(pattern).replacement(replacement);
    }

    @Nonnull
    public static Format format(@Nonnull String pattern, @Nonnull String replacement) {
        return new Format().pattern(pattern).replacement(replacement);
    }

    @Override
    @XmlElement(name="include", required=false, namespace="https://jemoni.echocat.org/schemas/jmx2carbonRules.xsd")
    public List<ObjectRule> getIncludes() {
        return super.getIncludes();
    }

    @Override
    public void setIncludes(List<ObjectRule> includes) {
        super.setIncludes(includes);
    }

    @Override
    @XmlElement(name="exclude", required=false, namespace="https://jemoni.echocat.org/schemas/jmx2carbonRules.xsd")
    public List<ObjectRule> getExcludes() {
        return super.getExcludes();
    }

    @Override
    public void setExcludes(List<ObjectRule> excludes) {
        super.setExcludes(excludes);
    }

    @XmlAttribute(name="pattern", required=true)
    @XmlJavaTypeAdapter(value=PatternAdapter.class)
    public Pattern getPattern() {
        return this._pattern;
    }

    public void setPattern(Pattern pattern) {
        this._pattern = pattern;
    }

    @XmlAttribute(name="replacement", required=true)
    public String getReplacement() {
        return this._replacement;
    }

    public void setReplacement(String replacement) {
        this._replacement = replacement;
    }

    @Nonnull
    public String format(@Nonnull String in) {
        String result;
        Pattern pattern = this._pattern;
        String replacement = this._replacement;
        if (pattern != null) {
            Matcher matcher = pattern.matcher(in);
            result = matcher.replaceAll(replacement != null ? replacement : "");
        } else {
            result = in;
        }
        return result;
    }

    @Nonnull
    public Format pattern(@Nonnull Pattern pattern) {
        this.setPattern(pattern);
        return this;
    }

    @Nonnull
    public Format pattern(@Nonnull String pattern) {
        return this.pattern(Pattern.compile(pattern));
    }

    @Nonnull
    public Format replacement(@Nonnull String replacement) {
        this.setReplacement(replacement);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        boolean result;
        if (o == this) {
            result = true;
        } else if (!super.equals(o) || o.getClass() != Format.class) {
            result = false;
        } else {
            Format that = (Format)o;
            result = (this._pattern != null ? this._pattern.equals(that._pattern) : that._pattern == null) && (this._replacement != null ? this._replacement.equals(that._replacement) : that._replacement == null);
        }
        return result;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this._pattern != null ? this._pattern.hashCode() : 0);
        result = 31 * result + (this._replacement != null ? this._replacement.hashCode() : 0);
        return result;
    }

    public String toString() {
        List<ObjectRule> excludes;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append('{');
        sb.append("pattern=").append(this._pattern);
        sb.append(", replacement=").append(this._replacement);
        List<ObjectRule> includes = this.getIncludes();
        if (includes != null && !includes.isEmpty()) {
            sb.append(", includes=").append(includes);
        }
        if ((excludes = this.getExcludes()) != null && !excludes.isEmpty()) {
            sb.append(", excludes=").append(excludes);
        }
        sb.append('}');
        return sb.toString();
    }
}

