/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jemoni.carbon.spring;

import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jemoni.carbon.CarbonWriter;
import org.echocat.jomon.runtime.util.Duration;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class WriterDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    public static final String ADDRESS_ATTRIBUTE = "address";
    public static final String MAX_BUFFER_LIFETIME_ATTRIBUTE = "maxBufferLifetime";
    public static final String CHARSET_ATTRIBUTE = "charset";

    protected Class<?> getBeanClass(Element element) {
        return CarbonWriter.class;
    }

    protected void doParse(@Nonnull Element element, @Nonnull BeanDefinitionBuilder bean) {
        bean.addPropertyValue(ADDRESS_ATTRIBUTE, (Object)this.toSocketAddress(element.getAttribute(ADDRESS_ATTRIBUTE)));
        bean.addPropertyValue(MAX_BUFFER_LIFETIME_ATTRIBUTE, (Object)this.toMaxBufferLifetime(element.getAttribute(MAX_BUFFER_LIFETIME_ATTRIBUTE)));
        bean.addPropertyValue(CHARSET_ATTRIBUTE, (Object)this.toCharset(element.getAttribute(CHARSET_ATTRIBUTE)));
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = super.resolveId(element, definition, parserContext);
        return StringUtils.hasText((String)id) ? id : this.getBeanClass(element).getName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    protected InetSocketAddress toSocketAddress(@Nullable String plain) {
        InetSocketAddress address;
        if (plain != null) {
            String trimmedText = plain.trim();
            if (!trimmedText.isEmpty()) {
                int port;
                int lastDoubleDot = trimmedText.lastIndexOf(58);
                if (lastDoubleDot <= 0 || lastDoubleDot + 1 >= trimmedText.length()) throw new IllegalArgumentException("Port missing");
                String host = trimmedText.substring(0, lastDoubleDot).trim();
                String plainPort = trimmedText.substring(lastDoubleDot + 1).trim();
                try {
                    port = Integer.parseInt(plainPort);
                }
                catch (NumberFormatException ignored) {
                    throw new IllegalArgumentException("Illegal port: " + plainPort);
                }
                address = new InetSocketAddress(host, port);
            } else {
                address = null;
            }
        } else {
            address = null;
        }
        if (address != null) return address;
        throw new IllegalArgumentException("Could not interpret '" + plain + "' as network socket address.");
    }

    @Nonnull
    protected Duration toMaxBufferLifetime(@Nullable String plain) {
        return StringUtils.hasText((String)plain) ? new Duration(plain) : CarbonWriter.DEFAULT_MAX_BUFFER_LIFETIME;
    }

    @Nonnull
    protected Charset toCharset(@Nullable String plain) {
        return StringUtils.hasText((String)plain) ? Charset.forName(plain) : CarbonWriter.DEFAULT_CHARSET;
    }
}

