/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jemoni.carbon.jmx.configuration;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.management.ObjectName;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.echocat.jemoni.carbon.jmx.AttributeDefinition;
import org.echocat.jemoni.carbon.jmx.configuration.AttributeRule;
import org.echocat.jemoni.carbon.jmx.configuration.PatternRule;

@XmlType(name="object", namespace="https://jemoni.echocat.org/schemas/jmx2carbonRules.xsd")
public class ObjectRule
extends PatternRule<ObjectRule> {
    private List<AttributeRule> _attributeRules;

    @Nonnull
    public static ObjectRule object() {
        return new ObjectRule();
    }

    @XmlElement(name="attribute", required=false, namespace="https://jemoni.echocat.org/schemas/jmx2carbonRules.xsd")
    public List<AttributeRule> getAttributeRules() {
        return this._attributeRules;
    }

    public void setAttributeRules(List<AttributeRule> attributeRules) {
        this._attributeRules = attributeRules;
    }

    @Nullable
    public Boolean apply(@Nullable AttributeDefinition input) {
        Boolean attributesMatch;
        Boolean patternMatch;
        Boolean result = input == null ? Boolean.valueOf(false) : ((patternMatch = this.apply(input, this.getPattern())) != null && patternMatch != false ? Boolean.valueOf((attributesMatch = this.apply(input, this._attributeRules)) == null || attributesMatch != false) : patternMatch);
        return result;
    }

    @Nullable
    protected Boolean apply(@Nonnull AttributeDefinition input, @Nullable Pattern pattern) {
        ObjectName objectName;
        Boolean result = pattern == null ? null : ((objectName = input.getObjectName()) == null ? Boolean.valueOf(false) : Boolean.valueOf(pattern.matcher(objectName.toString()).matches()));
        return result;
    }

    @Nullable
    protected Boolean apply(@Nonnull AttributeDefinition input, @Nullable List<AttributeRule> attributeRules) {
        Boolean result = null;
        if (attributeRules != null) {
            for (AttributeRule attributeRule : attributeRules) {
                Boolean attributeMatch = attributeRule.apply(input);
                if (attributeMatch == null) continue;
                result = attributeMatch;
                if (!attributeMatch.booleanValue()) continue;
                break;
            }
        }
        return result;
    }

    @Nonnull
    public ObjectRule attributes(@Nullable List<AttributeRule> attributes) {
        this.setAttributeRules(attributes);
        return this;
    }

    @Nonnull
    public ObjectRule attributes(AttributeRule ... attributes) {
        return this.attributes(attributes != null ? Arrays.asList(attributes) : null);
    }

    @Override
    public boolean equals(Object o) {
        boolean result;
        if (super.equals(o)) {
            ObjectRule that = (ObjectRule)o;
            result = this._attributeRules != null ? this._attributeRules.equals(that._attributeRules) : that._attributeRules == null;
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this._attributeRules != null ? this._attributeRules.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return super.toString() + "->" + this._attributeRules;
    }
}

