/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jemoni.carbon.jmx.configuration;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.lang.StringUtils;
import org.echocat.jemoni.carbon.jmx.configuration.AttributeRule;
import org.echocat.jemoni.carbon.jmx.configuration.Configuration;
import org.echocat.jemoni.carbon.jmx.configuration.Format;
import org.echocat.jemoni.carbon.jmx.configuration.ObjectRule;
import org.echocat.jemoni.carbon.jmx.configuration.Rule;
import org.echocat.jemoni.carbon.jmx.configuration.RulesConstants;
import org.w3c.dom.Node;

public class RulesMarshaller {
    private static final JAXBContext JAXB_CONTEXT;
    private static final Object NAMESPACE_PREFIX_MAPPER;

    @Nullable
    public static Configuration unmarshall(@Nullable String content) {
        try {
            return StringUtils.isEmpty((String)content) ? null : (Configuration)RulesMarshaller.unmarshallerFor(content).unmarshal((Reader)new StringReader(content));
        }
        catch (JAXBException e) {
            throw new RuntimeException("Could not unmarshall: " + content, e);
        }
    }

    @Nonnull
    public static Configuration unmarshall(@Nonnull Reader reader) throws IOException {
        try {
            return (Configuration)RulesMarshaller.unmarshallerFor(reader).unmarshal(reader);
        }
        catch (JAXBException e) {
            throw new IOException("Could not unmarshall " + reader + ".", e);
        }
    }

    @Nonnull
    public static Configuration unmarshall(@Nonnull Node rulesElement) {
        try {
            JAXBElement jaxbElement = rulesElement != null ? RulesMarshaller.unmarshallerFor(rulesElement).unmarshal(rulesElement, Configuration.class) : null;
            return jaxbElement != null ? (Configuration)jaxbElement.getValue() : null;
        }
        catch (JAXBException e) {
            throw new RuntimeException("Could not unmarshall " + rulesElement + ".", e);
        }
    }

    @Nonnull
    protected static Unmarshaller unmarshallerFor(@Nullable Object element) {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = JAXB_CONTEXT.createUnmarshaller();
            unmarshaller.setSchema(RulesConstants.SCHEMA);
        }
        catch (JAXBException e) {
            throw new RuntimeException("Could not create unmarshaller to unmarshall " + element + ".", e);
        }
        return unmarshaller;
    }

    public static void marshall(@Nonnull Configuration configuration, @Nonnull Writer to) throws IOException {
        try {
            RulesMarshaller.marshallerFor(configuration).marshal((Object)configuration, to);
        }
        catch (JAXBException e) {
            throw new IOException("Could not marshall " + configuration + " to " + to + ".", e);
        }
    }

    @Nullable
    public static String marshall(@Nullable Configuration configuration) {
        String result;
        if (configuration != null) {
            StringWriter to = new StringWriter();
            try {
                RulesMarshaller.marshallerFor(configuration).marshal((Object)configuration, (Writer)to);
            }
            catch (JAXBException e) {
                throw new RuntimeException("Could not marshall " + configuration + ".", e);
            }
            result = to.toString();
        } else {
            result = null;
        }
        return result;
    }

    @Nonnull
    private static Marshaller marshallerFor(@Nonnull Configuration configuration) {
        Marshaller marshaller;
        try {
            marshaller = JAXB_CONTEXT.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setSchema(RulesConstants.SCHEMA);
            if (NAMESPACE_PREFIX_MAPPER != null) {
                marshaller.setProperty("com.sun.xml.internal.bind.namespacePrefixMapper", NAMESPACE_PREFIX_MAPPER);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create marshaller to marshall " + configuration + ".", e);
        }
        return marshaller;
    }

    private RulesMarshaller() {
    }

    static {
        Object namespacePrefixMapper;
        try {
            JAXB_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{Configuration.class, Rule.class, Format.class, ObjectRule.class, AttributeRule.class});
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create jaxb context.", e);
        }
        try {
            namespacePrefixMapper = RulesMarshaller.class.getClassLoader().loadClass(RulesMarshaller.class.getPackage().getName() + ".RulesNamespacePrefixMapper").newInstance();
        }
        catch (Throwable ignored) {
            namespacePrefixMapper = null;
        }
        NAMESPACE_PREFIX_MAPPER = namespacePrefixMapper;
    }
}

