/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jemoni.carbon.spring;

import javax.annotation.Nonnull;
import org.echocat.jemoni.carbon.jmx.Jmx2CarbonBridge;
import org.echocat.jemoni.carbon.jmx.configuration.Configuration;
import org.echocat.jemoni.carbon.jmx.configuration.RulesMarshaller;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Jmx2CarbonBridgeDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    public static final String JMX_REGISTRY_REF_ATTRIBUTE = "jmxRegistry-ref";
    public static final String MBEAN_SERVER_REF_ATTRIBUTE = "mBeanServer-ref";
    public static final String WRITER_REF_ATTRIBUTE = "writer-ref";
    public static final String CLASS_LOADER_REF_ATTRIBUTE = "classLoader-ref";
    public static final String PATH_PREFIX_ATTRIBUTE = "pathPrefix";
    public static final String CONFIGURATION_ELEMENT = "configuration";
    public static final String CONFIGURATION_REF_ATTRIBUTE = "configuration-ref";

    protected Class<?> getBeanClass(Element element) {
        return Jmx2CarbonBridge.class;
    }

    protected void doParse(@Nonnull Element element, @Nonnull BeanDefinitionBuilder bean) {
        String pathPrefix;
        String jmxRegistryRef = element.getAttribute(JMX_REGISTRY_REF_ATTRIBUTE);
        String mBeanServerRef = element.getAttribute(MBEAN_SERVER_REF_ATTRIBUTE);
        if (StringUtils.hasText((String)jmxRegistryRef)) {
            if (StringUtils.hasText((String)mBeanServerRef)) {
                throw new IllegalArgumentException("The jmxRegistry-ref and mBeanServer-ref attributes could not be used at the same time.");
            }
            bean.addConstructorArgReference(jmxRegistryRef);
        } else if (StringUtils.hasText((String)mBeanServerRef)) {
            bean.addConstructorArgReference(mBeanServerRef);
        }
        bean.addConstructorArgReference(element.getAttribute(WRITER_REF_ATTRIBUTE));
        String classLoaderRef = element.getAttribute(CLASS_LOADER_REF_ATTRIBUTE);
        if (StringUtils.hasText((String)classLoaderRef)) {
            bean.addPropertyReference("classLoader", classLoaderRef);
        }
        if (StringUtils.hasText((String)(pathPrefix = element.getAttribute(PATH_PREFIX_ATTRIBUTE)))) {
            bean.addPropertyValue(PATH_PREFIX_ATTRIBUTE, (Object)pathPrefix);
        }
        Configuration configuration = null;
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!CONFIGURATION_ELEMENT.equals(child.getLocalName()) || !"https://jemoni.echocat.org/schemas/jmx2carbonRules.xsd".equals(child.getNamespaceURI())) continue;
            configuration = RulesMarshaller.unmarshall(child);
        }
        String rulesRef = element.getAttribute(CONFIGURATION_REF_ATTRIBUTE);
        if (StringUtils.hasText((String)rulesRef)) {
            if (configuration != null) {
                throw new IllegalArgumentException("The configuration element and configuration-ref attribute could not be used at the same time.");
            }
            bean.addPropertyReference(CONFIGURATION_ELEMENT, rulesRef);
        } else {
            bean.addPropertyValue(CONFIGURATION_ELEMENT, configuration);
        }
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = super.resolveId(element, definition, parserContext);
        return StringUtils.hasText((String)id) ? id : this.getBeanClass(element).getName();
    }
}

