/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jemoni.jmx;

import java.lang.management.ManagementFactory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMX;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;
import org.apache.commons.lang3.StringUtils;
import org.echocat.jemoni.jmx.BeanFacade;
import org.echocat.jemoni.jmx.BeanFacadeFactory;
import org.echocat.jemoni.jmx.Registration;
import org.echocat.jemoni.jmx.RegistrationWithFacade;

public class JmxRegistry {
    private static final JmxRegistry LOCAL_INSTANCE = new JmxRegistry();
    private final RegistrationHandler _handler = new RegistrationHandler();
    private final MBeanServer _server;
    private BeanFacadeFactory _beanFacadeFactory = new BeanFacadeFactory();

    @Nonnull
    public static JmxRegistry getLocalInstance() {
        return LOCAL_INSTANCE;
    }

    public JmxRegistry() {
        this(ManagementFactory.getPlatformMBeanServer());
    }

    public JmxRegistry(MBeanServer server) {
        this._server = server;
    }

    @Nonnull
    public MBeanServer getServer() {
        return this._server;
    }

    @Nonnull
    public BeanFacadeFactory getBeanFacadeFactory() {
        return this._beanFacadeFactory;
    }

    public void setBeanFacadeFactory(@Nonnull BeanFacadeFactory beanFacadeFactory) {
        if (this == LOCAL_INSTANCE) {
            throw new IllegalStateException("Modification of the local instance of " + JmxRegistry.class.getName() + " is not supported.");
        }
        this._beanFacadeFactory = beanFacadeFactory;
    }

    @Nonnull
    public Registration register(@Nonnull DynamicMBean bean, @Nonnull ObjectName withName) throws InstanceAlreadyExistsException {
        try {
            this._server.registerMBean(bean, withName);
        }
        catch (MBeanRegistrationException | NotCompliantMBeanException e) {
            throw new RuntimeException("Could not register " + bean + " at " + this._server + ".", e);
        }
        return new Registration(withName, bean, this._handler);
    }

    @Nonnull
    public Registration register(@Nonnull DynamicMBean bean, @Nonnull Class<?> forType) {
        return this.register(bean, forType, null);
    }

    @Nonnull
    public Registration register(@Nonnull DynamicMBean bean, @Nonnull Class<?> forType, @Nullable String variant) {
        Registration result = null;
        long instance = 0L;
        do {
            try {
                ObjectName objectName = this.getObjectNameFor(forType, instance > 0L ? Long.toString(instance) : null, variant);
                result = this.register(bean, objectName);
            }
            catch (InstanceAlreadyExistsException ignored) {
                ++instance;
            }
        } while (result == null);
        return result;
    }

    @Nonnull
    public <B> RegistrationWithFacade<B> register(@Nonnull B bean, @Nonnull ObjectName withName) throws InstanceAlreadyExistsException {
        BeanFacade<B> facade = this._beanFacadeFactory.createFor(bean);
        this.register((DynamicMBean)facade, withName);
        return new RegistrationWithFacade<B>(withName, facade, (Registration.Handler)this._handler);
    }

    @Nonnull
    public <B> RegistrationWithFacade<B> register(@Nonnull B bean, @Nullable String variant) {
        RegistrationWithFacade<B> result = null;
        long instance = 0L;
        do {
            try {
                ObjectName objectName = this.getObjectNameFor(bean.getClass(), instance > 0L ? Long.toString(instance) : null, variant);
                result = this.register(bean, objectName);
            }
            catch (InstanceAlreadyExistsException ignored) {
                ++instance;
            }
        } while (result == null);
        return result;
    }

    @Nonnull
    public <B> RegistrationWithFacade<B> register(@Nonnull B bean) {
        return this.register(bean, (String)null);
    }

    @Nonnull
    public ObjectName getObjectNameFor(@Nonnull Class<?> type, @Nullable String instance, @Nullable String variant) {
        StringBuilder sb = new StringBuilder();
        Package aPackage = type.getPackage();
        String packageName = aPackage != null ? aPackage.getName() : null;
        String typeName = type.getName();
        if (!StringUtils.isEmpty((CharSequence)packageName)) {
            sb.append(packageName);
            sb.append(!StringUtils.isEmpty((CharSequence)variant) ? ":type=" : ":name=");
            sb.append(typeName.substring(packageName.length() + 1));
        } else {
            sb.append("_");
            sb.append(!StringUtils.isEmpty((CharSequence)variant) ? ":type=" : ":name=");
            sb.append(typeName);
        }
        if (!StringUtils.isEmpty((CharSequence)instance)) {
            sb.append('.').append(this.normalize(instance));
        }
        if (!StringUtils.isEmpty((CharSequence)variant)) {
            sb.append(",name=").append(this.normalize(variant));
        }
        try {
            return new ObjectName(sb.toString());
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Could not create a valid object name for " + typeName + " and variant '" + variant + "'.", e);
        }
    }

    @Nonnull
    public <T> T getMBeanProxy(@Nonnull String mbeanName, @Nonnull Class<T> mbeanInterface) {
        try {
            return this.getMBeanProxy(new ObjectName(mbeanName), mbeanInterface);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Could not create object name for " + mbeanName + ".", e);
        }
    }

    @Nonnull
    public <T> T getMBeanProxy(@Nonnull ObjectName objectName, @Nonnull Class<T> mbeanInterface) {
        try {
            boolean emitter = this.getServer().isInstanceOf(objectName, NotificationEmitter.class.getName());
            return JMX.newMXBeanProxy(this.getServer(), objectName, mbeanInterface, emitter);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create mbean proxy for " + objectName + ".", e);
        }
    }

    @Nonnull
    public <T> T getMBeanProxy(@Nonnull Class<T> mbeanInterface, @Nonnull String instance) {
        ObjectName objectName = this.getObjectNameFor(mbeanInterface, instance, null);
        return this.getMBeanProxy(objectName, mbeanInterface);
    }

    @Nonnull
    protected String normalize(@Nonnull String what) {
        char[] in = what.toCharArray();
        char[] out = new char[in.length];
        int i = 0;
        for (char c : in) {
            if (Character.isLetterOrDigit(c) || c == '_' || c == '-' || c == '.') {
                out[i++] = c;
                continue;
            }
            if (!Character.isWhitespace(c)) continue;
            out[i++] = 95;
        }
        return new String(out, 0, i);
    }

    public class RegistrationHandler
    implements Registration.Handler {
        @Override
        public void unregister(@Nonnull Registration registration) throws Exception {
            try {
                JmxRegistry.this._server.unregisterMBean(registration.getObjectName());
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                // empty catch block
            }
        }
    }
}

